#include <alloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
/*

 Use enviroment variable DEBUG.
 f.e.
 set debug=PRN


*/



/*
   all theese functions are in _FARHEAP.ASM
*/
void _free(void  * block);
void _farfree(void far *block);
void *_malloc(size_t size);
void far *_farmalloc(unsigned long nbytes);
void *_realloc(void *block, size_t size);
void far *_farrealloc(void far *oldblock, unsigned long nbytes);



static int registered=0;
static doprint=0;
static FILE * out=0;
static char outputerrormsg[]="\n Error writing debug file\n";

static void closefile(void)
  {
    if(out){doprint=0;fclose(out);}
 }
static void openfile(void)
   {
char * debug_name;
    debug_name=getenv("DEBUG");
    if( (debug_name==0) || (*debug_name=='\0') ) return;
    out=fopen(debug_name,"wt");
    registered=1;
    if(out) doprint=1;
  }
#pragma startup openfile 70
#pragma exit closefile 70



  void dprintf(const char * format,...)
   { va_list ap;
     if(!doprint) return;
     va_start(ap,format);
     vfprintf(out,format,ap);
     fflush(out);
     if(ferror(out)) {fprintf(stderr,outputerrormsg);abort();}
     va_end(ap);
   }


/*
 theese functions can be used for debug purposes !
*/

static char debugging_memory_management[]=
      "debugging C memory management:";

void free(void  * block)
 { _free(block);
   dprintf("%s       free %p\n",debugging_memory_management,block);
  }

void farfree(void far *block)
   {_farfree(block);
   dprintf("%s    farfree %Fp\n",debugging_memory_management,block);
    }

void *malloc(size_t size)
   {void * result= _malloc(size);
    dprintf("%s     malloc %p for %u bytes\n",
	 debugging_memory_management,result,size);
    return result;}

void far *farmalloc(unsigned long nbytes)
   {void far * result= _farmalloc(nbytes);
    dprintf("%s  farmalloc %Fp for %lu bytes\n",
	 debugging_memory_management,result,nbytes);
    return result;
   }

void *realloc(void *block, size_t size)
   { void * result=_realloc(block,size);
    dprintf("%s    realloc %p to %p for %u bytes\n",
	    debugging_memory_management,block,result,size);
    return result; }

void far *farrealloc(void far *oldblock, unsigned long nbytes)
   { void far * result=_farrealloc(oldblock,nbytes);
    dprintf("%s farrealloc %Fp to %Fp for %lu bytes\n",
	    debugging_memory_management,oldblock,result,nbytes);
    return result; }

