/* ELEMENT.H  Element is the "pressable object" which may be drawed using
   vector graphics methods - lines, circles and so on */

#ifndef __ELEMENT_H_
#define __ELEMENT_H_

#include "press.h"

enum { NO_ELEMENT = 1,
       LEFT_ELEMENT, RIGHT_ELEMENT, UP_ELEMENT, // types of elements
		DN_ELEMENT, PG_UP_ELEMENT, PG_DN_ELEMENT,// may be expanded
		CANCEL_ELEMENT, OK_ELEMENT,
		HOME_ELEMENT, END_ELEMENT, MOVE_ELEMENT, RESIZE_ELEMENT,
		BLACK_ELEMENT, BLUE_ELEMENT, GREEN_ELEMENT, CYAN_ELEMENT,
                RED_ELEMENT, MAGENTA_ELEMENT, BROWN_ELEMENT,
		LIGHTGRAY_ELEMENT, DARKGRAY_ELEMENT, LIGHTBLUE_ELEMENT,
		LIGHTGREEN_ELEMENT, LIGHTCYAN_ELEMENT, LIGHTRED_ELEMENT,
                LIGHTMAGENTA_ELEMENT, YELLOW_ELEMENT, WHITE_ELEMENT };

class Element : public Press
    {
    protected:
	int type;
        int pattern;
    public:
	Element(loc l, int t, BORDERS b_type = BUTTON_BORDER,
	    int pat = 0)
	    : Press(rect(l.X, l.Y, l.X + 2, l.Y + 1), b_type)
	    { type = t; pattern = pat; }

	Element(rect c, int t, BORDERS b_type = BUTTON_BORDER,
	    int pat = 0, int tog = 0)
	    : Press(c, b_type, tog)
	    { type = t; pattern = pat; }

        int get_pattern() { return pattern; }
	virtual void show();
	virtual rect bounds()
	    { return tog ? rectangle : screenRect(rectangle); }
        void set_type(int t) { type = t; }
    };


#endif __ELEMENT_H_