#include <stdlib.h>
#include "draw.h"

#include "dim.h"         // "Ruber" figures
#include "icon.h"        // Used with microscope
#include "edit.h"        // text output with LJ fonts, in Horiz and Vert directions
#include "drawappl.h"
#include "filter.h"
#include "simple.h"
#include <string.h>
#include "imagebuf.h"
#include "effects.h"
#include "tools.h"
#include "gbuf.h"

extern void fill_area(loc from, int a, int b, char* f, rect r); // FILL.CPP


int* read_line_N(int num, char* fileName)        // Filter matrix
    {                                            // reading from disk
    FILE* filt = fopen(fileName, "r");
    char* pat = new char[100];
    for(int i = 0; i < num; i++)
	{
	pat = fgets(pat, 99, filt);
	}
    fclose(filt);
    int* kernel = new int[9];
    kernel[0] = atoi(strtok(pat, " ,;"));
    for(int k = 1; k < 9; k++)
	{
	kernel[k] = atoi(strtok(NULL, " ,;"));
	}
    delete pat;
    return kernel;
    }
///////////////////////
loc get_dither(int num, int* dither)
    {                                               // x
    FILE* dit;				            // y
    if((dit = fopen("dither.src", "r")) == NULL)    // a1 b1 c1...
	return loc(0, 0);
    char* pat = new char[100];                      // ...
						    // @
    int i = 0;
    while(i < num)                   // move to the given matrice
	{
//	fgets(pat, 99, dit);
	if(fgets(pat, 99, dit) == NULL)
	    {
	    delete pat;
            fclose(dit);
	    return loc(0, 0);
	    }
	if(pat[0] == '@')
	    i++;
	}

    pat = fgets(pat, 10, dit);    // read the matrice dimentions
    int x = atoi(pat);
    pat = fgets(pat, 10, dit);
    int y = atoi(pat);
    for(int j = 0; j < y; j++)
	{
	pat = fgets(pat, 99, dit);
	dither[j * x] = (atoi(strtok(pat, " ,;")));
	for(int k = 1; k < x; k++)
	    {
	    dither[j * x + k] = (atoi(strtok(NULL, " ,;")));
	    }
	}
    fclose(dit);
    delete pat;
    return loc(x, y);
    }
///////////////////////
Draw::Draw(rect coordinates)
	: Window(coordinates, "", "", 0, NO_BORDER, NO_BORDER, FIXED, 0)
    {
    saved = 1;
    }
/////////////////////////
Draw::~Draw()
    {
    kh_draw->askSave();
    unlink("copy.pcy");
    }
///////////////////////////
loc Draw::verify_rect(rect r)
    {
    loc mspos = e.where();
    if(mspos.X < r.origin.X)
        mspos.X = r.origin.X;
    if(mspos.X > r.corner.X)
        mspos.X = r.corner.X;
    if(mspos.Y < r.origin.Y)
        mspos.Y = r.origin.Y;
    if(mspos.Y > r.corner.Y)
        mspos.Y = r.corner.Y;
    return mspos;
    }
////////////////////////

void mouse_move(loc ms)
    {
    mouseHideCursor();
    mouseSetPosition(ms);
    mouseShowCursor();
    }
//////////////////////////
int Draw::do_scroll(int key, GrafBuffer* buf)
    {
    if(kh_draw->DATA_ZOOM)
	return 1;
    mouseHideCursor();
    rect r = user_screen();

    switch(key)
	{
	case EVENT_LEFT:
	    buf->scroll(pScreenSet->cell_width * 2, RIGHT); break;
	case EVENT_RIGHT:
	    buf->scroll(pScreenSet->cell_width * 2, LEFT); break;
	case EVENT_UP:
	    buf->scroll(pScreenSet->cell_height * 2, DN); break;
	case EVENT_DN:
	    buf->scroll(pScreenSet->cell_height * 2, UP); break;
	case EVENT_HOME:
	    buf->scroll((r.width() / 4) / 8 * 8, RIGHT); break;
	case EVENT_END:
	    buf->scroll((r.width() / 4 ) / 8 * 8, LEFT); break;
	case EVENT_PG_UP:
	    buf->scroll((r.height() / 4), DN);
	    break;
	case EVENT_PG_DN:
	    buf->scroll((r.height() / 4), UP);
	    break;
	case EVENT_F1:
	    global_i[0] = action_type; return 1;
	case EVENT_F6:
	case EVENT_ESC:
	case EVENT_F2:
	case EVENT_F10:
	case EVENT_TAB:
	    global_num = global_i[0] = 0; //unhilite();
	    mouseShowCursor(); return 1;
	}
    return 0;
    }
////////////////////////
void Draw::exe(int act)
    {
    if(!kh_draw->buffer->loaded)
	{
	e.what = KEYEVENT;
	e.key = EVENT_F10;
	global_num = global_i[0] = 0;
	return;
	}

    rect r = user_screen();
    kh_draw->DATA_X = global_i[10];      // Message exchange between
    kh_draw->DATA_Y = global_i[11];      // Microscope and Draw

    if(global_i[0] == AC_MICROSCOPE_2    // We exits MICROSCOPE with OK command
	&& !kh_draw->DATA_ZOOM)
	{
	void* image = get_image("copy.res", 1);
	putimage(kh_draw->DATA_X, kh_draw->DATA_Y, image, COPY_PUT);
	delete image;
	kh_draw->DATA_X = kh_draw->DATA_Y = 0;
	}
    global_i[0] = action_type;

    if(kh_draw->DATA_TOOLS == TOOL_UNDO && !kh_draw->DATA_ZOOM)        // UNDO
	{
	mouseHideCursor();
	if(pcx_file_scr("undo.pcy", r.origin))
	    unlink("undo.pcy");
	else
	    {
	    kh_draw->buffer->b_open();
	    kh_draw->buffer->buffer_screen();
	    kh_draw->buffer->b_close();
	    }
	mouseShowCursor();
	}
    else if(kh_draw->DATA_TOOLS != TOOL_LOCAL_UNDO && !kh_draw->DATA_ZOOM)
	{
	mouseHideCursor();
	if(kh_draw->DATA_TRANS)
	    pcx_scr_file(r, "undo.pcy");
	else
	    {
	    kh_draw->buffer->b_open();
	    kh_draw->buffer->screen_buffer();
	    kh_draw->buffer->b_close();
	    }
	mouseShowCursor();
	}

    int on = 0;
    if(kh_draw->DATA_TOOLS == TOOL_SCROLL && !kh_draw->DATA_ZOOM)   // SCROLL
	kh_draw->buffer->b_open();
    loc ms = e.where();
    while(1)
	{
	if((!act && !(e.what == MOUSEEVENT && !on))
	    || (kh_draw->DATA_TOOLS == TOOL_FILL))
	    get_event(1);            // We do not begin FILL it immediately
	else
	    on = 1;
	if(e.what == KEYEVENT && kh_draw->DATA_TOOLS != TOOL_SCROLL)
	    {
	    int z = (kh_draw->DATA_ZOOM > 0) ? kh_draw->DATA_ZOOM : 100;
	    rect reserv = r;
	    if(kh_draw->DATA_ZOOM)
		r = rect(r.origin,
		    loc(r.origin.X + (long)kh_draw->buffer->buf_dim.X * 100 / z,
			r.origin.Y + (long)kh_draw->buffer->buf_dim.Y * 100 / z));

	    if(!(r.contains(e.where())))      // if mouse is outside the DRAW
		{
		mouseSetPosition(r.origin);   // set mouse inside DRAW
	        ms = r.origin;
                }
	    mouseSetRange(r);                 // block leaving DRAW using kbd
	    switch(e.key)
		{
		case EVENT_LEFT:
		    mouse_move(ms = loc(ms.X - pScreenSet->cell_width, ms.Y));
                    readevent();
		    break;
		case EVENT_RIGHT:
		    mouse_move(ms = loc(ms.X + pScreenSet->cell_width, ms.Y));
		    readevent();
		    break;
		case EVENT_UP:
		    mouse_move(ms = loc(ms.X, ms.Y - pScreenSet->cell_height));
                    readevent();
		    break;
		case EVENT_DN:
		    mouse_move(ms = loc(ms.X, ms.Y + pScreenSet->cell_height));
		    readevent();
		    break;
		case EVENT_HOME:
		    mouse_move(ms = r.origin);
		    readevent();
		    break;

		case EVENT_F1:
		    global_i[0] = action_type; mouseDefaultRange(); return;
		case EVENT_F6:
		case EVENT_F10:
		case EVENT_TAB:
		case EVENT_ALT_F3:
		case EVENT_ALT_F4:
		case EVENT_ALT_TAB:
		    if(!kh_draw->DATA_ZOOM)
			{
			kh_draw->buffer->b_open();
			kh_draw->buffer->screen_buffer();
			kh_draw->buffer->b_close();
			}
		    global_num = global_i[0] = 0;
		    mouseDefaultRange(); r = reserv;
		    return;
		case EVENT_F2:
		case EVENT_RETURN:
		    mouseDefaultRange(); r = reserv;
		    draw();
		    break;
		}
	    r = reserv;
	    mouseDefaultRange();
	    }
	else if(e.what == KEYEVENT && !kh_draw->DATA_ZOOM)    // SCROLL
	    {
	    if(do_scroll(e.key, kh_draw->buffer))
		return;
	    }
	else
	    {
	    if(!mouse_in(e.where()))    // outside of draw box
		{
		global_num = global_i[0] = 0;
                if(!kh_draw->DATA_ZOOM && !kh_draw->w1->mouse_in(e.where()))
                    {
		    kh_draw->buffer->b_open();
		    kh_draw->buffer->screen_buffer();
		    kh_draw->buffer->b_close();
                    }
		return;
		}
	    else   // We are inside draw, we do not scroll and we use mouse
		draw();
	    }
	mouseShowCursor();
	}
    }
/////////////////////
void Draw::load()              // load new file
    {
    int z = (kh_draw->DATA_ZOOM > 0) ? kh_draw->DATA_ZOOM : 100;
    mouseHideCursor();
    kh_draw->buffer->screen_position = rect(loc(0, 0),
	kh_draw->buffer->screen_position.corner
	 - kh_draw->buffer->screen_position.origin);

    FILE* tmp;
    if((tmp = fopen(global[global_i[1]], "r")) != NULL)
	{
	fclose(tmp);
	kh_draw->buffer->b_open();
	if(pcx_file_buffer(kh_draw->buffer, loc(0, 0), global[global_i[1]]))
            kh_draw->buffer->buffer_screen(loc(z, z), loc(100, 100));
	kh_draw->buffer->b_close();
	}
    mouseShowCursor();
    saved = 1;
    }
/////////////////////
void Draw::show()
    {
    mouseHideCursor();
    Window::show();
    kh_draw->buffer->screen_position = rect(loc(0, 0),
	kh_draw->buffer->screen_position.corner
	 - kh_draw->buffer->screen_position.origin);

    if(kh_draw->buffer->loaded == 0)
	return;

    int z = (kh_draw->DATA_ZOOM > 0) ? kh_draw->DATA_ZOOM : 100;

    kh_draw->buffer->b_open();
    kh_draw->buffer->buffer_screen(loc(z, z), loc(100, 100));
    kh_draw->buffer->b_close();
    mouseShowCursor();
    }
//////////////////////
void Draw::repose(rect rec)
    {
    Window::repose(rec);
    rect r = user_screen();
//    r.origin.X += 8 - r.origin.X % 8 + 1;
//    r.corner.X -= r.corner.X % 8;
    r.corner.Y -= 1;
    kh_draw->buffer->screen_area = r;
    kh_draw->buffer->screen_position = rect(0, 0,
				 r.width() - 1, r.height() - 1);
    }
//////////////////////
void Draw::save()
    {
    mouseHideCursor();
    kh_draw->buffer->b_open();
    if(!kh_draw->DATA_ZOOM)
	kh_draw->buffer->screen_buffer();
    kh_draw->buffer->pcx_buffer_file(rect(0, 0,
        (kh_draw->buffer->buf_dim.X - 1) / 8 * 8 - 1,
			    kh_draw->buffer->buf_dim.Y - 1),
			    global[global_i[1]]);
    kh_draw->buffer->b_close();
    mouseShowCursor();
    saved = 1;
    }
///////////////////////
void Draw::new_file(rect r, int hide)    // clears work area
    {
    mouseHideCursor();
    struct fillsettingstype fillinfo;
    getfillsettings(&fillinfo);
    setfillstyle(SOLID_FILL, getmaxcolor());

    bar(r);
    setfillstyle(fillinfo.pattern, fillinfo.color);
    mouseShowCursor();
    if(hide)
	{
	FILE* Buf = fopen(kh_draw->buffer->file_name, "w+b");
	fclose(Buf);
	kh_draw->buffer->screen_position = rect(loc(0, 0),
	    kh_draw->buffer->screen_position.corner
	    - kh_draw->buffer->screen_position.origin);

	kh_draw->buffer->b_open();
	kh_draw->buffer->clear();
	kh_draw->buffer->b_close();
	saved = 1;
	}
    }
/////////////////////
int Draw::cut_copy(char* copyName)
    {
    rect r = user_screen();
    loc mspos = verify_rect(r);
    rect reserv1 = r;
    r.origin.X += 8 - r.origin.X % 8;
    int z = (kh_draw->DATA_ZOOM > 0) ? kh_draw->DATA_ZOOM : 100;
    rect reserv = r;
    if(kh_draw->DATA_ZOOM)
	r = rect(r.origin,
	    loc(r.origin.X + (long)kh_draw->buffer->buf_dim.X * 100 / z,
	    r.origin.Y + (long)kh_draw->buffer->buf_dim.Y * 100 / z));
    loc minsize = loc(pScreenSet->cell_width, pScreenSet->cell_height);
    rect work = get_dim(FIG_RECTANGLE, RESIZE, reserv1,
	rect(mspos, mspos + minsize));
    r = reserv;
    if(work.origin.X == work.corner.X ||   // cancel operation
       work.origin.Y == work.corner.Y)
	{
	r = reserv1;
	return saved;
	}
    rect reserv4;
    kh_draw->buffer->b_open();
    if(!kh_draw->DATA_ZOOM)
	kh_draw->buffer->screen_buffer();
    kh_draw->buffer->pcx_buffer_file(
		 reserv4 =
		 rect((kh_draw->buffer->screen_position.origin.X +
		     (long)(work.origin.X
		     - kh_draw->buffer->screen_area.origin.X)
		      * z / 100 + 7) / 8 * 8,
		 kh_draw->buffer->screen_position.origin.Y +
		     (long)(work.origin.Y
	     - kh_draw->buffer->screen_area.origin.Y)
		      * z / 100,
	 (kh_draw->buffer->screen_position.origin.X +
		     (long)(work.corner.X
		     - kh_draw->buffer->screen_area.origin.X)
		      * z / 100 + 7) / 8 * 8 - 1,
		 kh_draw->buffer->screen_position.origin.Y +
		     (long)(work.corner.Y
		     - kh_draw->buffer->screen_area.origin.Y)
		      * z / 100),
		 copyName);
    if(kh_draw->DATA_EDIT == 1 && !kh_draw->DATA_ZOOM)    // CUT
	{
        saved = 0;
//	color_bar(work, kh_draw->DATA_FILL, 16);
	color_grad(work, kh_draw->DATA_GRAD);
	}
    else if(kh_draw->DATA_EDIT == 1 && kh_draw->DATA_ZOOM)
	{
        saved = 0;
	setcolor(kh_draw->DATA_ATTR);
	setfillpattern((uchar*)::pattern[kh_draw->DATA_FILL],
		       kh_draw->DATA_BAK);
	bar(kh_draw->buffer, reserv4);
	kh_draw->buffer->buffer_screen(work, loc(z, z), loc(100, 100));
	}
    kh_draw->buffer->b_close();
    r = reserv1;
    return saved;
    }
/////////////////////
int Draw::paste(char* copyName)
    {
    rect r = user_screen();
    loc mspos = verify_rect(r);
    rect reserv1 = r;
//    r.origin.X += 8 - r.origin.X % 8;
    pcxheader header;
    if(!get_pcx_header(copyName, &header))
	return saved;;
    int z = (kh_draw->DATA_ZOOM > 0) ? kh_draw->DATA_ZOOM : 100;
    rect reserv = r;
    rect work;
    if(kh_draw->DATA_ZOOM)
	r = rect(r.origin.X + 1, r.origin.Y + 1,
	    r.origin.X + ((long)kh_draw->buffer->buf_dim.X - 8) * 100 / z - 1,
		r.origin.Y + (long)kh_draw->buffer->buf_dim.Y * 100 / z - 1);
    loc size((header.x2 - header.x1 + 1) * (long)100 / z,
	     (header.y2 - header.y1 + 1) * (long)100 / z);
    int mode = FIG_RECTANGLE;
    if(kh_draw->DATA_PREVIEW && !kh_draw->DATA_ZOOM
        && !strcmp("copy.pcy", copyName))
        mode = FIG_PCX;
    work = get_dim(mode, MOVE, r,
	rect(loc(r.origin.X, r.origin.Y),
	     r.origin + size), size);
    r = reserv;
    if(work.origin.X == work.corner.X ||
       work.origin.Y == work.corner.Y)
	{
	r = reserv1;
	return saved;
	}
    mspos = work.origin;
    if(kh_draw->DATA_ZOOM || kh_draw->DATA_TRANS)
	{
	kh_draw->buffer->b_open();
	int col = 17;                  // No such color -> pixel processing
	if(kh_draw->DATA_TRANS)
	    col = kh_draw->DATA_BAK;
	pcx_file_buffer(kh_draw->buffer,
	    loc((kh_draw->buffer->screen_position.origin.X +
	    (long)(mspos.X - kh_draw->buffer->screen_area.origin.X)
		      * z / 100), // + 7) / 8 * 8,!!!!!!!!!!!!!!!!!!!!!!!!
	    kh_draw->buffer->screen_position.origin.Y +
	    (long)(mspos.Y - kh_draw->buffer->screen_area.origin.Y)
		* z / 100),
	    copyName, col);
	kh_draw->buffer->buffer_screen(work, loc(z, z), loc(100, 100));
	kh_draw->buffer->b_close();
	}
    else
	pcx_file_scr(copyName, work.origin);
    r = reserv1;
    return 0;
    }
/////////////////////
int Draw::filter_func()
    {
    rect r = user_screen();
    loc mspos = e.where();
    if(kh_draw->DATA_ZOOM)
	return saved;
    loc minsize = loc(pScreenSet->cell_width, pScreenSet->cell_height);
    rect work = get_dim(FIG_RECTANGLE, RESIZE, r,
		rect(mspos, mspos + minsize));
    if(work.origin.X == work.corner.X ||
       work.origin.Y == work.corner.Y)
	return saved;
    int* kernel = read_line_N(kh_draw->DATA_FILTER, "filter.src");

    color_filter(kernel, work);
    delete kernel;
    return 0;
    }
////////////////////
int Draw::dither_func()
    {
    rect r = user_screen();
    loc mspos = e.where();
    int z = (kh_draw->DATA_ZOOM > 0) ? kh_draw->DATA_ZOOM : 100;
    rect reserv = r;
    loc minsize = loc(pScreenSet->cell_width, pScreenSet->cell_height);
    if(kh_draw->DATA_ZOOM)
	r = rect(r.origin,
	    loc(r.origin.X + (long)kh_draw->buffer->buf_dim.X * 100 / z,
		    r.origin.Y + (long)kh_draw->buffer->buf_dim.Y * 100 / z));

    rect work = get_dim(FIG_RECTANGLE, RESIZE, r,
		rect(mspos, mspos + minsize));
    r = reserv;
    if(work.origin.X == work.corner.X ||
       work.origin.Y == work.corner.Y)
	return saved;
    loc dim;

    rect work1(kh_draw->buffer->screen_position.origin.X +
		     (long)(work.origin.X
		     - kh_draw->buffer->screen_area.origin.X)
		      * z / 100,
		 kh_draw->buffer->screen_position.origin.Y +
		     (long)(work.origin.Y
		     - kh_draw->buffer->screen_area.origin.Y)
		      * z / 100,
		 kh_draw->buffer->screen_position.origin.X +
		     (long)(work.corner.X
		     - kh_draw->buffer->screen_area.origin.X)
		      * z / 100,
		 kh_draw->buffer->screen_position.origin.Y +
		     (long)(work.corner.Y
		     - kh_draw->buffer->screen_area.origin.Y)
		      * z / 100);

    if(kh_draw->DATA_DITHER == 0 && !kh_draw->DATA_ZOOM)    // special case
	{
        if(!kh_draw->DATA_ERROR_PROP)
            for(int y = work.origin.Y; y < work.corner.Y; y++)
	        for(int x = work.origin.X;
		    x < work.corner.X; x++)
		    {
		    putpixel(x, y,
		        (bw_pix((uchar)(getpixel(x, y)), x, y)
			   ? kh_draw->DATA_BAK : kh_draw->DATA_ATTR));
		    }
        else
            error_dither(work);
	return 0;
	}
    int dither[100];
    dim = get_dither(kh_draw->DATA_DITHER, dither);
    if(dim.X == 0)
	return saved;

    if(kh_draw->DATA_ZOOM)
	{
	kh_draw->buffer->b_open();
        if(!kh_draw->DATA_ERROR_PROP)
            dither_BW(dither, work1, dim, kh_draw->buffer);
        else
            error_dither_buf(kh_draw->buffer, work1);

	kh_draw->buffer->buffer_screen(work, loc(z, z),
			      loc(100, 100));
	kh_draw->buffer->b_close();
	}
    else
	if(!kh_draw->DATA_ERROR_PROP)
	    dither_BW(dither, work, dim);
        else
            error_dither(work);

    return 0;
    }
////////////////////
void Draw::draw()                              // draw processing
    {
    global_i[6] = kh_draw->DATA_ATTR;
    global_i[7] = kh_draw->DATA_BAK;
    global_i[8] = kh_draw->DATA_ERROR_PROP;
    global_i[9] = kh_draw->DATA_FILL;
    global_i[12] = kh_draw->DATA_TOOLS;
    rect r = user_screen();                                // work area
    setlinestyle(SOLID_LINE, 1, kh_draw->DATA_LINE);
    setcolor(kh_draw->DATA_ATTR);                                   // draw color
//    setfillpattern(pattern[kh_draw->DATA_FILL], kh_draw->DATA_BAK);

    int dis = kh_draw->DATA_LINE;                               // line width - 3

    e = readevent();                    // get mouse position
    loc mspos = verify_rect(r);

    loc minsize = loc(pScreenSet->cell_width, pScreenSet->cell_height);
    rect work;
    mouseHideCursor();
    switch(kh_draw->DATA_TOOLS)                     // draw function from tools menu
	{
	case TOOL_SCISSORS:
	    switch(kh_draw->DATA_EDIT)
		{
		case 1:                  // CUT
		case 2:                  // COPY
		    saved = cut_copy();
		    break;
		case 6:                   // PASTE
		    saved = paste();
		    break;
		}
	    break;
	case 14:           // Filters
	    saved = filter_func();
	    break;
	case 15:           // Dither
	    saved = dither_func();
	    break;
	case 16:           // LOCAL UNDO
	    if(kh_draw->DATA_ZOOM)
		break;
	    work = get_dim(FIG_RECTANGLE, RESIZE, r,
				rect(mspos, mspos + minsize),
				loc(0, 0), loc(1, 1));
	    if(work.origin.X != work.corner.X
		&& work.origin.Y != work.corner.Y)
		{
                saved = 0;
		kh_draw->buffer->b_open();
		kh_draw->buffer->buffer_screen(work);
		kh_draw->buffer->b_close();
		}
	    break;
	case 3:    // ERASER
	case 4:    // COLOR ERASER
	case 6:    // RECTANGLE
	case 7:    // CIRCLE
	case 8:    // LINE
	    if(kh_draw->DATA_ZOOM)
		break;                    // to be changed with KNOW-HOW.VBGI
	    int f_type = FIG_RECTANGLE;
	    if(kh_draw->DATA_TOOLS == 7)
		f_type = FIG_CIRCLE;
	    else if(kh_draw->DATA_TOOLS == 8)
		f_type = FIG_LINE;
	    work = get_dim(f_type, RESIZE, r,
				rect(mspos, mspos + minsize),
				loc(0, 0), loc(1, 1));
	    if(work.origin.X != work.corner.X
		|| work.origin.Y != work.corner.Y)
		{
                saved = 0;
		switch(kh_draw->DATA_TOOLS)
		    {
		    case 3:                            	       // ERASER
		    case TOOL_COLOR_ERASER:
			color_grad(work, kh_draw->DATA_GRAD); break;
		    case 6:
			while(dis--)
			    {
			    ::rectangle(work);
			    work.origin.X += 1;
			    work.origin.Y += 1;
			    work.corner.X -= 1;
			    work.corner.Y -= 1;
			    }
			break;
		    case 7:
			setlinestyle(SOLID_LINE, 1, 1);
			while(dis-- && work.width() > 0 && work.height() > 0)
			    {
			    ellipse(work.origin.X + work.width() / 2,
				work.origin.Y + work.height() / 2, 0, 360,
				work.width() / 2, work.height() / 2);
			    work.origin.X += 1;
			    work.origin.Y += 1;
			    work.corner.X -= 1;
			    work.corner.Y -= 1;
			    }
			break;

		    case 8:
			while(dis--)
			    {
                            //work.sort();
			    line(work.origin, work.corner);
			    loc sh = (abs(work.width()) > abs(work.height()))
				     ? loc(0, 1) : loc(1, 0);

			    work.origin.X += sh.X;
			    work.origin.Y -= sh.Y;
			    work.corner.X += sh.X;
			    work.corner.Y -= sh.Y;
			    }
			break;
		    }
		}
	    break;
	case 5:    // FILL
	    if(kh_draw->DATA_ZOOM)
		break;
	    char pattern[8];
	    getfillpattern(pattern);
            saved = 0;
	    fill_area(mspos, kh_draw->DATA_ATTR, kh_draw->DATA_BAK, pattern, r);
	    break;
	case 9:    // PEN
	    if(kh_draw->DATA_ZOOM)
		break;
	    mspos = e.where();
	    while(1)
		{
		get_event(2);

		if(e.what == MOUSEEVENT
		   && (e.msstatus.buttonstate == MOUSERIGHT ||
		   e.msstatus.buttonstate == MOUSELEFT || !r.contains(mspos))
		    || e.what == KEYEVENT && (e.key == EVENT_RETURN || e.key == EVENT_ESC))
		    break;
                saved = 0;
		if(e.what == KEYEVENT)
		    switch(e.key)
			{
			case EVENT_LEFT: mspos.X--; break;
			case EVENT_RIGHT: mspos.X++; break;
			case EVENT_UP: mspos.Y--; break;
			case EVENT_DN: mspos.Y++; break;
			}
		else
		    mspos = e.where();
		color_bar(rect(mspos.X, mspos.Y, mspos.X + 2 * kh_draw->DATA_LINE,
		    mspos.Y + 2 * kh_draw->DATA_LINE), kh_draw->DATA_FILL, 48);
		}
	    break;
	case 10:   // TEXT
	    if(kh_draw->DATA_ZOOM)
		break;
	    if(kh_draw->fontName == NULL)
		return;

	    ljfont*  fnt = new ljfont(kh_draw->fontName);
	    saved = 0;
	    text_edit1(mspos, r, fnt, kh_draw->DATA_SIZE, kh_draw->DATA_DIR, kh_draw->DATA_ATTR);
	    break;
	}
    mouseShowCursor();

    settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
    settextjustify(LEFT_TEXT, TOP_TEXT);
    }
////////////////////




