#ifndef __CHOICE_BOX_H_
#define __CHOICE_BOX_H_

#include "visible.h"
#include "context.h"
#include "item.h"
#include "window.h"

class ChoiceBox : public Window, public Context
    {
    protected:
	char* hot;            // string of hot keys
	int pos;              // current position
	int start;            // start position
	loc itemSize;         // dimentions of item, calculated of given


	int*   itemList;      // items, if they are integer
	int raw, column;      // num of raws and columns in menu, calculated

	int available;        // if size is too small - do not show

        loc itemDistance;     // between items
	Item* item;           // for system use
    public:
        int count;            // num of items, calculated
        char** itemStrings;   // items, if they are strings

	ChoiceBox(rect coordinates, char* fName = "", char* h = "",
	       char* HOT = NULL, int POS = 1, int START = 1,
	       loc ITEMSIZE = loc(1, 1), char** ITEMSTRINGS = NULL,
	       int* ITEMLIST = NULL,
	       loc ITEMDISTANCE = loc(8, 8),
	       rect STATUSPOS = rect(0, 24, 79, 25),
	       int STATUSTYPE = 0, char** STATUSSTRINGS = NULL,
	       int* STATUSLIST = NULL,
	       int res = FIXED, int s = 3, BORDERS b_type = SHOW_BORDER,
	       BORDERS hdr_b_type = SHOW_BORDER, int pat = 0,
	       int hdr_pat = 0);
	virtual ~ChoiceBox() { delete item; }

	int get_choice() { return pos; }
	void moveTo(int number);
        void endOfList();           // if EOL - moveto 1 or load new portion
	void left();
	void right();
	void up();
	void dn();
	void home();
	void end();
	void pgUp();
	void pgDn();
	void toTop();
	void toBottom();

        char** getItemStrings() { return itemStrings; }
	void calcConsts();
	virtual void calcItemsNumber() {}
	rect getItemCoord();
	virtual void showItem()    {}
	int mouseOn(event where);  // on what position mouse pressed
        int get_page_size() { return raw * column; }
        int get_items_number() { return count; }

	virtual void show();
        virtual void hide();
	virtual void repose(rect new_coord);

	virtual void exe(int act = 0);
    };

#endif __CHOICE_BOX_H_