#include "blpxtab.h"

BlockPXTable::BlockPXTable(rect coordinates,
	       char* tabName,
	       char* fName,
	       char* h,
	       int s,
	       BORDERS b_type,
	       BORDERS hdr_b_type,
	       int res,
	       int hdr_pat,
	       int elem_pat,
	       int fNo,
	       char** fields,
	       char** types)
	: Block(coordinates, fName, h, s, res, b_type, hdr_b_type, 0, hdr_pat,
	    elem_pat)
    {
    table = new KH_PX_Table(rect(coordinates.origin.X + 1 + textX(s),
	     coordinates.origin.Y + 2 + textY(s),
	     coordinates.corner.X - 1 - textX(s),
	     coordinates.corner.Y - 3 - textY(s)),

	     tabName, "", "", 0, b_type, NO_BORDER, FIXED, 0,
	     fNo, fields, types);

    table->set_ret(1);
    insert(table, 1);

    int xw = 2 * pScreenSet->cell_width;
    int yh = pScreenSet->cell_height;
    int xl = screenXL(coordinates.origin.X) + w1->get_shadow();
    int xr = screenXR(coordinates.origin.X) + w1->get_shadow() + xw;
    int yt = screenYT(coordinates.corner.Y) - w1->get_shadow() - 2 * yh;
    int yb = screenYB(coordinates.corner.Y) - w1->get_shadow() - 1 * yh;

    home_element = new Element(rect(xl, yt + yh, xr, yb + yh),
			 HOME_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    end_element = new Element(rect(xl + xw, yt + yh, xr + xw, yb + yh),
			 END_ELEMENT, BUTTON_BORDER, elem_pat, 1);
    ok_element = new Element(rect(xl + 5 * xw, yt + yh, xr + 5 * xw, yb + yh),
			 OK_ELEMENT, BUTTON_BORDER, elem_pat, 1);


    add(ok_element);
    add(home_element);
    add(end_element);

    assign(table, left_element, AC_LEFT);
    assign(table, right_element, AC_RIGHT);
    assign(table, up_element, AC_UP);
    assign(table, dn_element, AC_DOWN);
    assign(table, cancel_element, AC_CANCEL);
    assign(table, pg_up_element, AC_PG_UP);
    assign(table, pg_dn_element, AC_PG_DN);
    assign(table, home_element, AC_HOME);
    assign(table, end_element, AC_END);
    assign(table, ok_element, AC_OK);

    left_element->repose(rect(xl, yt, xr, yb));
    right_element->repose(rect(xl + xw, yt, xr + xw, yb));
    up_element->repose(rect(xl + 2 * xw, yt, xr + 2 * xw, yb));
    dn_element->repose(rect(xl + 2 * xw, yt + yh, xr + 2 * xw, yb + yh));
    pg_up_element->repose(rect(xl + 3 * xw, yt, xr + 3 * xw, yb));
    pg_dn_element->repose(rect(xl + 3 * xw, yt + yh, xr + 3 * xw, yb + yh));
    if(move_element != NULL)
        move_element->repose(rect(xl + 4 * xw, yt, xr + 4 * xw, yb));
    if(resize_element != NULL)
        resize_element->repose(rect(xl + 4 * xw, yt + yh, xr + 4 * xw, yb + yh));
    cancel_element->repose(rect(xl + 5 * xw, yt, xr + 5 * xw, yb));
    }
/////////////////////////////////
void BlockPXTable::rearrange()
    {
    rect sz = textRect(w1->bound());
    if(sz.width() < 32)
	sz.corner.X = sz.origin.X + 20;
    if(sz.height() < 6)
	sz.corner.Y = sz.origin.Y + 6;
    w1->repose(sz);
    Block::rearrange();
    rect r;
    rect coord = textRect(r = w1->bound());

    int xw = 2 * pScreenSet->cell_width;
    int yh = pScreenSet->cell_height;
    int xl = screenXL(coord.origin.X) + w1->get_shadow();
    int xr = screenXR(coord.origin.X) + w1->get_shadow() + xw;
    int yt = screenYT(coord.corner.Y) - w1->get_shadow() - 2 * yh;
    int yb = screenYB(coord.corner.Y) - w1->get_shadow() - 1 * yh;

    left_element->repose(rect(xl, yt, xr, yb));
    right_element->repose(rect(xl + xw, yt, xr + xw, yb));
    up_element->repose(rect(xl + 2 * xw, yt, xr + 2 * xw, yb));
    dn_element->repose(rect(xl + 2 * xw, yt + yh, xr + 2 * xw, yb + yh));
    pg_up_element->repose(rect(xl + 3 * xw, yt, xr + 3 * xw, yb));
    pg_dn_element->repose(rect(xl + 3 * xw, yt + yh, xr + 3 * xw, yb + yh));
    home_element->repose(rect(xl, yt + yh, xr, yb + yh));
    end_element->repose(rect(xl + xw, yt + yh, xr + xw, yb + yh));
    if(move_element != NULL)
        move_element->repose(rect(xl + 4 * xw, yt, xr + 4 * xw, yb));
    if(resize_element != NULL)
        resize_element->repose(rect(xl + 4 * xw, yt + yh, xr + 4 * xw, yb + yh));
    cancel_element->repose(rect(xl + 5 * xw, yt, xr + 5 * xw, yb));
    ok_element->repose(rect(xl + 5 * xw, yt + yh, xr + 5 * xw, yb + yh));

    table->repose(rect(coord.origin.X + 1 + textX(w1->get_shadow()),
		      coord.origin.Y + 2 + textY(w1->get_shadow()),
		      coord.corner.X - 1 - textX(w1->get_shadow()),
		      coord.corner.Y - 3 - textY(w1->get_shadow())));
    }
/////////////////////////
void BlockPXTable::hide()
    {
    table->hide();
    w1->hide();
    }
//////////////////////////////
/*
void main()
    {
    if(!init_KNOW_HOW())
	return;
    if(PXInit() != PXSUCCESS)
	return;

    setfillstyle(SOLID_FILL, pColorSet->colors.BAK_COLOR);
    bar(0, 0, getmaxx(), getmaxy());

    BlockPXTable w(rect(10, 2, 78, 14), "demo.db", "window.pcy",
	" KNOW-HOW 4.x", 3, SHOW_BORDER, SHOW_BORDER, MOVE | RESIZE, 19, 0);

    w.show_window();
    w.exe();
    w.hide();

    PXExit();
    close_KNOW_HOW();
    closegraph();
    }
*/