#include <stdlib.h>     // Demo only !!!
#include "bgipaint.h"
color_to_16 tricolors[16] =
    {   { BLACK, 0 },
        { BLUE, RGB(0, 0, 128) },
        { GREEN, RGB(0, 128, 0) },
        {  CYAN, RGB(0, 128, 128) },
        {  RED, RGB(128, 0, 0) },
        { MAGENTA, RGB(74, 23, 74) },
        { BROWN, RGB(128, 64, 64) },
        { LIGHTGRAY, RGB(128, 128, 128) },
        { DARKGRAY, RGB(64, 64, 64) },
        { LIGHTBLUE, RGB(0, 0, 255) },
        { LIGHTGREEN, RGB(0, 255, 0) },
        { LIGHTCYAN, RGB(0, 255, 255) },
        { LIGHTRED, RGB(255, 0, 0) },
        { LIGHTMAGENTA, RGB(255, 0, 255) },
        { YELLOW, RGB(255,255,30) },
        { WHITE, RGB(255, 255, 255) }
    };


int To_Paint::getcolor(COLORREF color)
    {
    int col = 0;
    COLORREF l;
    int a = 0;
    if(tricolors[0].colorref > color)
        {
        l = tricolors[0].colorref - color;
        a = 1;
        }
    else
        l = color - tricolors[0].colorref;
    for(int i = 0; i < 16; i++)
        {
        if(a)
            {
            if(l > tricolors[i].colorref - color)
                {
                col = i;
                l = tricolors[i].colorref - color;
                }
            }
        else
            if(l > color - tricolors[i].colorref)
                {
                col = i;
                l = color - tricolors[i].colorref;
                }
        }
    return col;
    }
////////////////////
#ifdef WIN_GDI

void To_Paint::lineto(int x, int y)
    {
    HPEN pen = CreatePen(PenStyle, PenSize, color);
    HPEN old_pen;
    (HGDIOBJ)old_pen = SelectObject(DC, pen);
    ::LineTo(DC, x, y);
    SelectObject(DC, old_pen);
    DeleteObject(pen);
    }
/////////////////////
void To_Paint::fillpoly(int numpoints, int* polypoints)
    {
    HPEN pen = CreatePen(PenStyle, PenSize, color);
    HPEN old_pen;
    (HGDIOBJ)old_pen = SelectObject(DC, pen);
    HBRUSH brush;
    if(pattern_num == SOLID_FILL)
        brush = CreateSolidBrush(BrushColor);
    else
        brush = CreateHatchBrush(pattern_num, BrushColor);
    HBRUSH old_brush;
    (HGDIOBJ)old_brush = SelectObject(DC, brush);
    ::Polygon(DC, (POINT*)polypoints, numpoints);
    SelectObject(DC, old_brush);
    DeleteObject(brush);
    SelectObject(DC, old_pen);
    DeleteObject(pen);
    }
//////////////////////
void To_Paint::drawpoly(int numpoints, int far* points)
    {
    HPEN pen = CreatePen(PenStyle, PenSize, color);
    HPEN old_pen;
    (HGDIOBJ)old_pen = SelectObject(DC, pen);
    ::Polyline(DC, (POINT*)points, numpoints);
    SelectObject(DC, old_pen);
    DeleteObject(pen);
    }

#endif WIN_GDI
//////////////////////////////////////////////////////

KH_Paint::KH_Paint()
    : To_Paint(),
      Paint()
      {
      }

int KH_Paint::getx()
    {
    int x = To_Paint::getx();
    loc pos(transform(x, 0));
    return pos.X;
    }
//////////////////////////
int KH_Paint::gety()
    {
    int y = To_Paint::gety();
    loc pos(transform(0, y));
    return pos.Y;
    }
//////////////////////////
void KH_Paint::putpixel(int x, int y)
    {
    loc pos(transform(x, y));
    To_Paint::putpixel(pos.X, pos.Y);
    }
//////////////////
void KH_Paint::lineto(int x, int y)
    {
    loc to(transform(x, y));
    To_Paint::lineto(to.X, to.Y);
    }
///////////////////
void KH_Paint::moveto(int x, int y)
    {
    loc to(transform(x, y));
    To_Paint::moveto(to.X, to.Y);
    }
///////////////////
void KH_Paint::ellipse(int x, int y, int stangle, int endangle, int xr, int yr)
    {
    if(xr <= 0 || yr <= 0)
        return;
    loc pos;
    pos = loc(x,y);
    long x1 = xr;
    long y1 = yr;
    moveto(pos.X + x1 * cos(stangle) / 1000,
           pos.Y - y1 * sin(stangle) / 1000);

    if(fill == OFF)
        for(int i = stangle; i <= endangle; i++)
            lineto(pos.X + x1 * cos(i) / 1000,
                   pos.Y - y1 * sin(i) / 1000);
    else
        {
        int points[730];                   // 360 * 2
        for(int i = stangle, j = 0; i < endangle; i++,j++)
            {
            points[2 * j] = (int)(pos.X + x1 * cos(i) / 1000);
            points[2 * j + 1] = (int)(pos.Y - y1 * sin(i) / 1000);
            }
        if((endangle - stangle) % 360)
            {
            points[2 * j] = pos.X;
            points[2 * j + 1] = pos.Y; j++;

            points[2 * j] = points[0];
            points[2 * j + 1] = points[1];
            }
        fillpoly(j, points);
        }
    }
///////////////////
void KH_Paint::drawpoly(int numpoints, int far* points)
    {
    for(int i = 0; i < numpoints * 2; i += 2)
        {
        loc tmp = transform(points[i], points[i + 1]);
        points[i] = tmp.X;
        points[i + 1] = tmp.Y;
        }
    if(fill == OFF)
        To_Paint::drawpoly(numpoints, points);
    else
        To_Paint::fillpoly(numpoints, points);
    }

///////////////////////////// End of DOS BGI part ///////////////////////////
void KH_Paint::rectangle(int x1, int y1, int x2, int y2)
    {
    int p[] =  { x1, y1, x2, y1, x2, y2, x1, y2, x1, y1 };
        drawpoly(5, p);
    }
///////////////////
void KH_Paint::outtext(uchar far* str, int dir)
    {
    outtextxy(getx(), gety(), str, dir);
    }
////////////////////
void KH_Paint::bar3d(int l, int t, int r, int b, int d, int top)
    {
    int poly[] = { l,t, r,t, r,b, l,b, l,t };
    fillpoly(5, poly);
    if(b >= t)
        {
        if(top)
            {
            int poly2[] = { r,t, r+d,t-d, l+d,t-d, l,t, r,t };
            drawpoly(5, poly2);
            }
        int poly1[] = { r,t, r,b, r+d,b-d, r+d,t-d, r,t };
        drawpoly(5, poly1);
        }
    else
        {
        if(top)
            {
            int poly2[] = { r,b, r+d,b-d, l+d,b-d, l,b, r,b };
            drawpoly(5, poly2);
            }
        int poly1[] = { r,t, r,b, r+d,b-d, r+d,t-d, r,t };
        drawpoly(5, poly1);
        }
    }
///////////////////// Common DOS/Windows part of the DEMO ///////////////////
//////////// This example draws "bird" and calendar for 1995 (1996) /////////
/*
#include <string.h>

class Demo : public KH_Paint
    {
    public:
        void demo();
        void bird();
        void dn(int, int);
        void wing(int, int);
        void pero(int, int, int);
        void calendar(int left, int top, int year, bool visocose);
        int mon(int x, int y, char* mon, int first_day, int num_of_days);
    };
///////////////////
void Demo::demo()
    {
    set_add_zoom(1,1);          // For all picture


    setfillstyle(SOLID_FILL, WHITE);
    set_fill(ON);
    set_zoom(0.1, 0.05);       // To the next "zoom" call
    rectangle(0, 0, 5000, 10000);

    set_scroll(800, 500);
    bird();
    set_scroll(0, 500);
    set_zoom(0.35, 0.33);

    setcolor(BLACK);
    load("trip.chr");
// Parameters: left, top, year, 0 if not visocose (1980 was)
    calendar(80, 120, 1995, 0);

    char s[] = { "  KNOW-HOW.GRAPHICS" };
    load("lcom.chr");
    set_scroll(0, 0);
    set_zoom(1, 1);
    setcolor(GREEN);
    for(int i = 0; i < strlen(s); i++)
        {
        rotate(loc(250, 250), 180 - 180 / strlen(s) * i);
        draw_char(480, 250, s[i], 0);
        }
    rotate(0,0,0);
    }
/////////////////
void Demo::calendar(int l, int t, int year, bool v)
    {
    int day = 7;              // for 1995
    if(year == 1996)          // add cone for other years or use some
        day = 1;              // calculations
    int x = l;
    int y = t + 15;
    for(int i = 1; i <= 3; i++)
        {
        outtextxy(x, y, "Mo");
        y += 30;
        outtextxy(x, y, "Tu");
        y += 30;
        outtextxy(x, y, "We");
        y += 30;
        outtextxy(x, y, "Th");
        y += 30;
        outtextxy(x, y, "Fr");
        y += 30;
        outtextxy(x, y, "Sa");
        y += 30;
        outtextxy(x, y, "Su");

        y += 100;
        }
    x = l + 100;
    y = t - 30;
    day = mon(x, y, "January", day, 31);
    int dv = v == 0 ? 28 : 29;

    day = mon(x + 340, y, "February", day, dv);
    day = mon(x + 680, y, "March", day, 31);
    day = mon(x + 1020, y, "April", day, 30);
    day = mon(x, y +280, "May", day, 31);
    day = mon(x + 340, y + 280, "June", day, 30);
    day = mon(x + 680, y + 280, "July", day, 31);
    day = mon(x + 1020, y + 280, "August", day, 31);
    day = mon(x, y + 560, "September", day, 30);
    day = mon(x + 340, y + 560, "October", day, 31);
    day = mon(x + 680, y + 560, "November", day, 30);
    day = mon(x + 1020, y + 560, "December", day, 31);
    }
//////////////
int Demo::mon(int x1, int y1, char* head, int start, int num)
    {
    set_fill(ON);
    setfillstyle(SOLID_FILL, WHITE);
    outtextxy(x1 + 60, y1, head);
    int days = 1;
    int ln = start;
    y1 += 15;

    char s[10];
    while(1)
        {
        if(days > num)
            return ln;
        if(ln > 7)
            {
            x1 += 50;
            ln = 1;
            continue;
            }
        outtextxy(x1, y1 + 30 * ln, itoa(days, s, 10));
        days++;
        ln++;
        }
    }
////////////////
void Demo::bird()
    {
    set_zoom(0.1, 0.05);       // To the next "zoom" call
    setlinestyle(1, SOLID_LINE);
    setcolor(BLUE);
    setfillstyle(SOLID_FILL, YELLOW);

    int dy = 30;
    for(int i = 1; i <= 12; i++)
        {
        ellipse(1600, 800 + 2 * dy * i, 0, 360, dy * i, dy * i);
        ellipse(1600, 2300 - 2 * dy * i, 0, 360, dy * i, dy * i);
        }
    dn(1800, 1800);
    wing(1900, 1400);
    set_mirror(1600);
    dn(1800, 1800);
    wing(1900, 1400);
    set_mirror(0);

    rotate(loc(0, 0), 0);
    ellipse(1600, 700, 0, 360, 360, 360);
    for(i = 0; i <= 60; i++)
        {
        pero(1800, 700, 1);
        rotate(loc(1600, 700), 6 * i);
        }
    rotate(loc(1600, 2000), -90);
    pero(1600, 2000, 7);
    rotate(loc(1600, 2000), -100);
    pero(1600, 2000, 5);
    rotate(loc(1600, 2000), -80);
    pero(1600, 2000, 5);

    rotate(loc(0, 0), 0);

    ellipse(1700, 600, 0, 360, 60, 130);
    ellipse(1500, 600, 0, 360, 60, 130);
    ellipse(1700, 600, 0, 360, 60, 60);
    ellipse(1500, 600, 0, 360, 60, 60);
    ellipse(1600, 800, 0, 360, 20, 90);
    }
//////////////////
void Demo::wing(int xwin, int ywin)
    {
    for(int i = 0; i <= 10; i++)
        {
        rotate(xwin, ywin, 20 * i - 120);
        pero(xwin, ywin, i / 2);
        }
    set_zoom(0.1, 0.05);
    }
/////////////////
void Demo::dn(int xdn, int ydn)
    {
    rotate(xdn + 40, ydn + 40, -180);
    for(int i = 0; i <= 19; i++)
        {
        rotate(xdn + 40, ydn + 40, 20 * i);
        pero(xdn, ydn, 1);
        }
    }
/////////////////
void Demo::pero(int x, int y, int sz)
    {
    int x1 = x + 40 * sz;
    int x2 = x + 100 * sz;
    int x3 = x + 230 * sz;
    int x4 = x + 300 * sz;
    int y1 = y - 20 * sz;
    int y2 = y - 30 * sz;
    int y3 = y + 20 * sz;
    int y4 = y + 30 * sz;
    int points[] = {  x1, y, x2, y1, x3, y2, x4, y, x3, y4, x2, y3, x1, y };
    fillpoly(7, points);
    line(x, y, x + 300, y);
    }
////////////////////// End of common DOS / Windows part /////////////////////
//////////////////////////////// BGI DOS Demo ///////////////////////////////

void main()
    {
    int gdriver = DETECT, gmode;
    initgraph(&gdriver, &gmode, "");

    Demo* paint = new Demo();
    paint->demo();

    delete paint;
    closegraph();
    }
*/
////////////////////////////// GDI Windows Demo /////////////////////////////
// This example demonstrates output to OWL window. If necessary,
// any other Windows library could be used.
/*
#include <owl.h>

class TMyApp : public TApplication
{
public:
  TMyApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

_CLASSDEF(TMyWindow)
class TMyWindow : public TWindow, public Demo
{
public:
  TMyWindow(PTWindowsObject AParent, LPSTR ATitle)
    : TWindow(AParent, ATitle), Demo() { DC = GetDC(HWindow); }
  virtual void WMLButtonDown(RTMessage Msg)
    = [WM_FIRST + WM_LBUTTONDOWN];
};

void TMyWindow::WMLButtonDown(RTMessage)
    {
    DC = GetDC(HWindow);
    demo();
    }

void TMyApp::InitMainWindow()
{
  MainWindow = new TMyWindow(NULL, Name);
}

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  TMyApp MyApp("Sample KNOW-HOW.GRAPHICS Program", hInstance, hPrevInstance,
               lpCmdLine, nCmdShow);
  MyApp.Run();
  return MyApp.Status;
}

*/