#include "ask_hot.h"
#include "blkmenu.h"
#include "button.h"

enum { SAVE = 1, DONT_SAVE };

int ask_save()
    {
    rect base;
    base = rect(20, 10, 50, 15);
    char* menuList[] = { "    Yes    ", "   No    ", "" };
    TextMenu* menu = new TextMenu(base, "ask_save.pcy",
	       " Save the file? Y/N", "YN", 1, 1,
	       menuList, rect(0, 24, 79, 25), 0, NULL,
	       NULL, FIXED, 6, SHOW_BORDER, SHOW_BORDER, 0, 16);

    menu->set_pos(2);
    menu->show_window();
    menu->exe();
    menu->hide();

    delete menu;

    if(global_num == SAVE)    // YES
	return 1;
    return 0;
    }
//////////////////////
int ask_exit()
    {
    rect base;
    base = rect(20, 10, 50, 15);

    char* menuList[] = { "    Yes   ", "    No    ", "" };
    TextMenu* ask_menu = new TextMenu(base, "ask_exit.pcy",
	       "Exit program? Y / N ", "YN", 1, 1,
	       menuList, rect(0, 24, 79, 25), 0, NULL,
	       NULL, FIXED, 6, SHOW_BORDER, SHOW_BORDER, 0, 16);
    ask_menu->show_window();
    ask_menu->exe();
    ask_menu->hide();
    if(global_num == 1)    // YES
	{
	delete ask_menu;
	return 1;          // exit
	}

    delete ask_menu;
    return 0;
    }
//////////////////////////
int ask_hot_key()    // shows the window with message and gets a key
    {                // for macros. Mouse or ESC are processed as CANCEL-type
    int a;           // event, visible characters are ignored

    Window* w = new Window(rect(29, 9, 46, 16),	"hotkey.pcx");
    Button* button = new Button(rect(30, 10, 45, 15),
	"Press hot key\nCTRL\nor ALT", NO_BORDER);

    w->show_window();           // window - the "dummy" way to hide button
    button->show();      // button

    while(1)
	{
	e = getevent(KEYEVENT | MOUSEEVENT);
	if((e.what = KEYEVENT && e.key == EVENT_ESC) // not possible
	    || e.what == MOUSEEVENT)                 // hot key
	    {
	    a = 0;                // if CANCEL-type event
	    break;
	    }
	if(!(e.is_char()))
	    {
	    a = 1;                // if char is visible
	    break;
	    }
	}
    w->hide();
    delete button;
    delete w;
    return a;   // a == 0 if CANCEL and a == 1 if hot key inserted
    }
/////////////////////////
void add_macros(char* command, FILE* tempPtr)  // add macros to macros file
    {
    char header[22];                       // new macros header
    header[0] = '$';                       // leadind '$'
    strcpy(header + 1, command);           // "$ <hot key> "
    header[strlen(command) + 1] = '\n';
    header[strlen(command) + 2] = '\0';    // "$ <hot key> \n\0"

    fputs(header, tempPtr);                // write it to file as the first line

    char str[82];
    while(fgets(str, 80, scriptPtr) > 0)   // copy all script to macros file
	{
	fputs(str, tempPtr);
	}
    fputc('\n', tempPtr);                  // not absolutely necessary

    while(fgets(str, 80, macrosPtr) > 0)   // copies last macroses from
	{                                  // macros file
	char* i;
	if(str[0] == '$' && !strncmp(str, header, strlen(str) - 2))          // if this macros is already defined
	    {
	    while((i = fgets(str, 80, macrosPtr))[0] != '$' // str = "$ <ALT_F1>\n"
		&& i)                                       // header = "$ ALT_F1> '\n"
		;                             // skip macros which is replaced
	    }
	fputs(str, tempPtr);
	}

    }
/////////////////////////