// This is the header for disk_arr class.

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

template <class T> class disk_arr_line;
template <class T> class disk_arr_element;

template <class T>
class disk_arr {
private:
	FILE *memfile;
   char *file_name;
	const long xsize, ysize;
   const char ftype;
   const char rcheck;
   char fstatus;
   T* zero_value;
   void range_error(long x, long y) const;
   friend class disk_arr_line<T>;
   friend class disk_arr_element<T>;
public:
	disk_arr(char *, long, long, const T&, char type=0, char check=0);
	disk_arr(const disk_arr&);
 	~disk_arr();
   char operator!() const { return (!fstatus); }
   disk_arr_line<T> operator[](long x) {
                      disk_arr_line<T> temp(x, this); return temp; }
};


template <class T>
class disk_arr_line {
private:
	const long x;
   disk_arr<T>* a;
   disk_arr_line(long x1, disk_arr<T>* a1):
   					x(x1), a(a1) {}
   friend class disk_arr<T>;
public:
   disk_arr_element<T> operator[](long y) {
						disk_arr_element<T> temp(x, y, a); return temp; }
};

template <class T>
class disk_arr_element {
private:
	const long x;
   const long y;
   disk_arr<T>* a;
   disk_arr_element(long x1, long y1, disk_arr<T>* a1):
                   x(x1), y(y1), a(a1) {}
   friend disk_arr_line<T>;
public:
   disk_arr_element<T> operator= (const T& r);
   disk_arr_element<T> operator= (disk_arr_element<T> el)
   										{ return (operator=(T(el))); }
   operator T() const;
};
