
;                         AceComm & Utilities (Tm)
;                             3.0
;
;                       AceComm Ascii Control File
;                  Use ACTL.EXE to compile into ACE.PRM
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;              ACE.CTL is
;                          A  Plain  Ascii  Text  File...
;                          Use  a  Plain  Ascii  Text  Editor...
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;; ============
;;;  Port Setup 
;;; ============
ADDRESS_A 3F8
IRQ_A 4
ADDRESS_B 2F8
IRQ_B 3
ADDRESS_C 3E8
IRQ_C 4
ADDRESS_D 2E8
IRQ_D 3
ADDRESS_E 230
IRQ_E 4
ADDRESS_F 238
IRQ_F 4
ADDRESS_G 240
IRQ_G 4
ADDRESS_H 248
IRQ_H 4
Port 1
;   o Connect speeds such as 12000, 14400 etc. are not actual
;     data rates that the UART (serial port)  can be set to.
;   o Setting the Baud rate to 19200 for a 9600 baud modem will
;     allow better performance when down loading data.
;   o Locking the port means selecting a baud rate higher than the
;     highest connect speed the modem is capable of, and telling the
;     communications software to lock it there.
;   o Modems capable of connecting at 9600 and above can usually be
;     used with a "Locked port"
;   o Using a locked port requires your modem be in full handshake
;     mode.
Baud 38400
LockBaud 
RBuff 16384
RBuff 256
FIFO_Trigger 8
;TX 
;Chain_IRQ 
CTS/RTS 
;XON/XOFF 
;Strip_HighBIT 
DropDTR 
;;; =================
;;;  Dialing Options 
;;; =================
InterByteDelay 1
DialTimeout 90
TimeBetweenRedial 3
;DTR_BetweenRedial 
DialConnectBell 1
;DCD_VerifyConnect 
;;; ===========================
;;;  Internal Protocol Options 
;;; ===========================
AutoEngage 
FileResume 
;XfrTimeSlice 
XfrBell 
;;; =================
;;;  General Options 
;;; =================
StatusLine 
LogFile 
;LogModemRes 
AutoSave 
;SnowCheck 
ScrnBlank 3
SwapSpawn 
SwapShell 
EnhancedKBD 
KeyRef 8
ScrlBakBuf 64
VideoRows 28
;;; =================
;;;  Pointer Options 
;;; =================
;MouseDetect 
;;; ======================
;;;  Colors, Menu Options 
;;; ======================
BorderAttr 7
BorderType 1
LeftFieldAttr 3
RightFieldAttr 7
DisplayATTR 48
TitleAttr 120
ITitleAttr 10
SelectorAttr 2
BurstMenu
;ChatterMenu 
;WhistleMenu 
TermColor 7
CurtainColor 22
CurtainChar 176
HelpLineColor 112
HelpScreenColor 7
HelpScreenTitleColor 26
HelpScreenKeyWordColor 122
HelpScreenSelectorColor 30
HelpScreenLastErrorColor 28
FonBorderAttr 16
FonBorderType 2
FonLeftFieldAttr 31
FonRightFieldAttr 11
FonDisplayAttr 48
FonTitleAttr 27
FonITitleAttr 26
FonSelectorAttr 30
;FonBurstMenu 
;FonChatterMenu 
;FonWhistleMenu 
DialBorderAttr 51
DialBorderType 2
DialLeftFieldAttr 63
DialRightFieldAttr 62
DialDisplayAttr 48
DialTitleAttr 62
DialITitleAttr 58
DialSelectorAttr 59
;DialBurstMenu 
;DialChatterMenu 
;DialWhistleMenu 
;;; =================
;;;  Sub Directories 
;;; =================
FonDir fon
Captures cap
Scripts scr
TermKey kts
DnldDir files
Screens screens
Nodelist mail_in
MailIn mail_in
MailOut mail_out
;;; =============
;;;  Modem Setup 
;;; =============
;
; - Modem command strings
;   Note: Mdm commands are automaticaly appended with
;         Mdm_Cmd_Line_Terminator at time the command string
;         is sent to the modem.
;         The `^` character is recognized as a Control character.
;         The byte following a `^` will become (byte - 64d)
;   Examples:
;             ^M translates to CR
;             ^A translates to 1, ^M translates to 13 (CR_CHAR)
;             ~ translates to  1 second delay
;             ` translates to  5 second delay
;             !, @, #, and $ are dial strin modifiers.
Mdm_Init_A +++ATZ^M~ATMQW2&C1&D2
Mdm_Init_B 
Mdm_Init_C 
Mdm_Dial_Prefix ATMEQ0V1X4DT
Mdm_Dial_Sufix 
Mdm_Answer ATA
Mdm_Hangup +++ATH0
Mdm_OffHook ATH1
Mdm_Abort ^M
Mdm_Reset ATZ
Mdm_Echo ATE1
Mdm_Host_Init_A  +++ATZ^M~ATMQW2&C1&D2
Mdm_Host_Init_B AT+FCLASS=2
Mdm_Host_Init_C
;
; Mdm_Cmd_Line_Terminator is automaticaly appended to all modem commands
Mdm_Cmd_Line_Terminator ^M
;
;
; - Modem Responce Strings
;   Note: The following strings are probably case sensitive
;                                   (see your modem manual)
Mdm_Res_OK OK^M
Mdm_Res_Ring RING^M
Mdm_Res_NoCarrier NO CARRIER
Mdm_Res_Error ERROR
Mdm_Res_NoDialTone NO DIAL TONE
Mdm_Res_Busy BUSY
Mdm_Res_NoAnswer NO ANSWER
Mdm_Res_Ringing RINGING^M
Mdm_Res_Voice VOICE
;
; - The following connect strings may be tailored any way you wish.
;   No particular order, refer to your modem manual for case and format.
; Note: ACECOMM will detect a carrier anyway, the connect strings
;       may speed things up, and will also allow automatic baud adjustments
;       when connecting at a speed not dialed out on, and port not locked.
;       With Lockbaud SET, the UART baud rate remains fixed, translation
;       is made by your modem.
Mdm_Res_Connect_A CONNECT 
Mdm_Res_Connect_B CARRIER
Mdm_Res_Connect_C FCON
User_Name_A
User_Name_B Alias
User_Name_C Melissa Jean
User_Pwd_A
User_Pwd_B password
User_Pwd_C kidstuff
;;; ========================
;;;  Interactive EMSI Setup 
;;; ========================
;
; IEMSI handshake data is an Auto Log-In standard used with BBS
; software.
;
IEMSI_Name
IEMSI_Alias 
IEMSI_Location 
IEMSI_Data_Pnum 
IEMSI_Voice_Pnum, 
IEMSI_Password
IEMSI_CRTDEF ANSI,24,80,0
IEMSI_Protocols Zap,ZMO
IEMSI_Capabilities CHT,TAB,ASCII8
IEMSI_Requests 
;;; ============
;;;  EMSI Setup 
;;; ============
;
; EMSI handshake data is the current mailer session protocol.
;
;
EMSI_System_Address 1:999/999
EMSI_Acka_A 
EMSI_Acka_B 
EMSI_System_Name AceComm Robot
EMSI_Sysop_Name
EMSI_City Emerald City, OZ
EMSI_Phone_Number
EMSI_Baud_Rate 115200
EMSI_Flags V32b,CM,XA
PassWord_A 1:114/12 mailman
PassWord_B 1:114/440 holdmail
PassWord_C 1:124/4115 betas
PassWord_D 1:114/245 mailman
PassWord_E 
BossAddress_A 1:114/35
BossName_A AceComm Suport BBS
BossPhone_A 1-602-846-2940
BossPwd_A password
BossBaud_A 38400
BossAddress_B 1:124/4115.227
BossName_B Roberts
BossPhone_B 1-214-339-4495
BossPwd_B 
BossBaud_B 
BossAddress_C 
BossName_C 
BossPhone_C 
BossPwd_C 
BossBaud_C 
BossAddress_D 
BossName_D 
BossPhone_D 
BossPwd_D 
BossBaud_D 
BossAddress_E 
BossName_E 
BossPhone_E 
BossPwd_E 
BossBaud_E 
AfterMailMacro <RunProg>EMAIL toss
ProgramStartMacro <DispStr>^M^I^I^I^I^I  AceComm Communications Software ^M^J
MailOnlyMacro <SendStr>^M^J[BWhi][Blu] Mail only hour!   [AttrOff]
LongDistanceDef_A 1-
DialModifier_A #70
DialModifier_B 
DialModifier_C 
DialModifier_D 
;;; ==================
;;;  Dial Translation 
;;; ==================
;
; AceComm can filter or translate phone numbers 
; To strip  1-612-  from  numbers:
; 1-612-        
; To modify  1-612-  into 1-     :
; 1-612-  1-    
; To modify  1-555-232-4000  into 1-555-232-4111  :
; 1-555-232-4000  1-555-232-4111    
;
DialTrans_A
DialTrans_B 1-602-292-0997 1-602-292-1111
DialTrans_C 
DialTrans_D 
DialTrans_E 
Request_file REQUEST.LST
Files_file MGP-SOFT.ZIP
About_file ABOUT.FIL
;;; ========================================================
;;;  Auto Engage Sequence Triggers, Associated Macro Stacks 
;;; ========================================================
PreAutoM 
PostAutoM 
AutoDnld_A rz^M**
AutoDnld_B HS*^B
AutoDnld_C 
AutoDnld_D MPt ^V^H
AutoDnld_E 
AutoDnld_F 
AutoDnld_G 
AutoDnld_H 
AutoDnld_I **EMSI_REQA77E
AutoDnld_J **EMSI_IRQ8E08
AutoMacro_A <RecvZmo>
AutoMacro_B <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
AutoMacro_C <RunProg>BIMODEM /L%P /R[DIR_DNLDS] Bimodem.Pth
AutoMacro_D <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]
AutoMacro_E 
AutoMacro_F 
AutoMacro_G 
AutoMacro_H 
AutoMacro_I <SendEMSI_CLI>
AutoMacro_J <SendEMSI_ICI>
;;; ========================================================
;;;  Auto Log On Sequence Triggers, Associated Macro Stacks 
;;; ========================================================
AutoLogOn_A is your name:
AutoLogOn_B Your FIRST name:
AutoLogOn_C Host Name:
AutoLogOn_D first name ?
AutoLogOn_E and LAST name:
AutoLogOn_F last name?
AutoLogOn_G first name?
AutoLogOn_H First and Last
AutoLogOn_I full name?
AutoLogOn_J 
AutoLogOn_K 
AutoLMacro_A <SendStr>[USER_NAME]^M~Y^M~[FON_PWD]^M
AutoLMacro_B <SendStr>[USER_NAME]^MY^M~[FON_PWD]^M
AutoLMacro_C <SendStr>CIS^M~~[FON_ID]^M~~[FON_PWD]^M
AutoLMacro_D <SendStr>[USER_NAME]^MY^M[FON_PWD]^M
AutoLMacro_E <SendStr>[USER_NAME]^M~^M~[FON_PWD]^M
AutoLMacro_F <SendStr>[USER_NAME]^M~~[FON_PWD]^M
AutoLMacro_G <SendStr>[USER_NAME]^M~~[FON_PWD]^M
AutoLMacro_H <SendStr>[USER_NAME]^M~~[FON_PWD]^M
AutoLMacro_I <SendStr>[USER_NAME]^M~^M[FON_PWD]^M
AutoLMacro_J 
AutoLMacro_K 
;;; ========================================================
;;;  Event Schedules, Associated Macro Stacks 
;;; ========================================================
;;    Sample Event an associated macro stack:
;; (Allow a mail event from midnight to 3am)
; Schedule_A    0:0-3:0,MAIL
;; (The macro stack will be run at beginning of event)
; SchedMacro_A  <ChgDir>c:\mail <RunProg>QM <ChgDir>[DIR_START]
Schedule_A 0:0-2:0,Mail,host,LD
Schedule_B 2:0-3:0,Mail,ld
Schedule_C 3:0-7:30,Mail,host
Schedule_D 7:30-12:00,Mail,host
Schedule_E 12:0-17:20,Mail,host
Schedule_F 17:20-20:0,Mail,host,ld
Schedule_G 20:0-23:45,Mail,host
Schedule_H 23:45-23:59,Mail,host
Schedule_I 0:0-0:0,Mail,Host,Ld
SchedMacro_A <RunScript>getmail.scr
SchedMacro_B 
SchedMacro_C 
SchedMacro_D 
SchedMacro_E <RunProg>EMAIL export
SchedMacro_F 
SchedMacro_G 
SchedMacro_H 
SchedMacro_I <DispStr>^J^M --- The Midnight Schedule! ---^J^M
;;; =========================================================
;;;  Auto Answer Connect Sub-string, Associated Macro Stacks 
;;; =========================================================
;;    Sub_string  - String to match in modem Answer/Connect string
;;    Macro stack - Macro stack to process on Answer/Connect
;;    Sample Sub-string and associated macro stack:
;AutoAnsSub-str_1 CONNECT
;AutoAnsMac_1 <RunProg>TRIBBS port %P baud %B
;;    Sample Sub-string and associated macro stack:
;AutoAnsSub-str_2 FAX
;AutoAnsMac_2 <RunProg>BGFAX /FAX %P Q
AutoAnswer_A CONNECT
AutoAnsMac_A 
AutoAnswer_B CARRIER
AutoAnsMac_B <DispStr>Error "CARRIER"^M^J
AutoAnswer_C FCON
AutoAnsMac_C <RunProg>COMMAND /C recvfax
DefaultMac <ChgDir>C:\BBS <RunProg>BBS %P %C <ChgDir>[DIR_START]
;;; =========================================================
;;;  Auto Answer C
ExtrnDn_A <RunProg>BIMODEM /L%P /R[DIR_DNLDS] Bimodem.Pth
ExtrnDn_B <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
ExtrnDn_C <RunProg>MPT P%P N+ F+ R+ R [DIR_DNLDS]
ExtrnDn_D <RunProg>JMODEM %PF %WK
ExtrnDn_E <RunProg>DSZ port %P speed %B rz -mrr [DIR_DNLDS]
ExtrnDn_F <RunProg>ozbext /B%B /C%P /F[DIR_DNLDS] /J /U /X
ExtrnDn_G 
ExtrnDn_H 
ExtrnDn_I 
ExtrnDn_J 
ExtrnUp_A <RunProg>BIMODEM /L%P /R[DIR_DNLDS] bimodem.pth
ExtrnUp_B <RunProg>HSLINK -P%P -U[DIR_DNLDS] @UPLDS.LST
ExtrnUp_C <RunProg>MPT P%P N+ F+ S @UPLDS.LST %WK
ExtrnUp_D <RunProg>JMODEM S %PF %WK
ExtrnUp_E <RunProg>DSZ port %P speed %B sz @[DIR_START]\UPLDS.LST
ExtrnUp_F <RunProg>COMMAND /C SENDFAX.BAT %PF %DN %WK
ExtrnUp_G 
ExtrnUp_H 
ExtrnUp_I 
ExtrnUp_J 
;;; =============
;;;  User Menus  
;;; =============
User_1_Title CIS Functions
User1_desc_A Forums Script
User1_macro_A <RunScript>cisforum.scr
User1_desc_B Bill Script
User1_macro_B <RunScript>cisbill.scr
User1_desc_C Compose Message
User1_macro_C <SendAscii>%P
User1_desc_D IBMPRO Forum 2 File
User1_macro_D <SendStr>go IbmPro^M <OpenCapture>prog[MODA] <Delay>5 <SendStr>Read New^M
User1_desc_E IBMCOM Forum 2 File
User1_macro_E <SendStr>go IbmCom^M <OpenCapture>comm[MODA] <Delay>5 <SendStr>Read New^M
User1_desc_F WINSDK Forum
User1_macro_F <SendStr>go winsdk^M <OpenCapture>wsdk[MODA] <Delay>9 <SendStr>Read New^M
User1_desc_G CIS Msg Reference
User1_macro_G <RunProg>List cis_msg.ref
User_2_Title OffLine Reader
User2_desc_A OffLine QWK Reader
User2_macro_A <ChgDir>D:\QWK <RunProg>OFFLINE <ChgDir>[DIR_START]
User2_desc_B Run Mail Script
User2_macro_B <RunScript>offline.scr
User2_desc_C EMAIL Point Reader
User2_macro_C <RunProg>EMAIL read
User2_desc_D 
User2_macro_D 
User2_desc_E 
User2_macro_E 
User2_desc_F 
User2_macro_F 
User2_desc_G Delete QWK Packet
User2_macro_G <FileDel>files\114-35.qwk
User_3_Title User Menu #3
User3_desc_A Description
User3_macro_A 
User3_desc_B Description 
User3_macro_B 
User3_desc_C Description
User3_macro_C 
User3_desc_D 
User3_macro_D 
User3_desc_E 
User3_macro_E 
User3_desc_F 
User3_macro_F 
User3_desc_G 
User3_macro_G 
User_4_Title User Menu #4
User4_desc_A 
User4_macro_A 
User4_desc_B 
User4_macro_B 
User4_desc_C 
User4_macro_C 
User4_desc_D 
User4_macro_D 
User4_desc_E 
User4_macro_E 
User4_desc_F 
User4_macro_F 
User4_desc_G 
User4_macro_G 
User_5_Title User Menu #5
User5_desc_A 
User5_macro_A 
User5_desc_B 
User5_macro_B 
User5_desc_C 
User5_macro_C 
User5_desc_D 
User5_macro_D 
User5_desc_E 
User5_macro_E 
User5_desc_F 
User5_macro_F 
User5_desc_G 
User5_macro_G 
;;; ==============
;;;  ALT A-Z, 1-0 
;;; ==============
;
; AceComm`s MACRO driven keyboard provides for easy key re-def
;
; You may define the keys any way you like, should you forget to
; assign an exit key, CTRL-BREAK from terminal mode will force the
; <EndACEComm> MACRO to be executed, CTRL-BREAK is an acceptable
; key-combo permanantly assigned to the <EndACEComm> MACRO
;
; Functions which end with `_` are not suited for scripts as they
; require local keyboard input.
ALT-A <AutoScrGen_>
ALT-B <ScrollBack_>
ALT-C <CaptureFile_>
ALT-D <PhoneList_>
ALT-E <Sheduler>
ALT-F <FileList_>[DIR_DNLDS]
ALT-G <FileReq_>
ALT-H <MdmHangUp_>
ALT-I 
ALT-J <DOSShell_>
ALT-K <AddLF2CR>
ALT-L <RunProg> list
ALT-M <Mailer_>
ALT-N <ChgDir>c:\mail\qm <RunProg>QM toss <ChgDir>[DIR_START]
ALT-O <PrmData_>
ALT-P <PrmData_>
ALT-Q 
ALT-R <RunScript_>
ALT-S <ScrnDump_>
ALT-T <ScrnTag_>
ALT-U <Users>
ALT-V <KeyRef_>
ALT-W 
ALT-X <EndAceComm> 0
ALT-Y <AutoAnswer>
ALT-Z <ClrWin>
ALT-1 <SendZmo> %PF
ALT-2 <RunProg>DSZ sz %PF %WK <SendStr> ^M
ALT-3 <SendAscii> %PF
ALT-4 <RunProg>BiPath 
ALT-5 
ALT-6 <RunProg> dsz rz -rm
ALT-7 <RunProg>bimodem bimodem.pth <SendStr>^M
ALT-8 
ALT-9 
ALT-10 
ALT-- 
ALT-= <DoorWayMode>
;;; ==========
;;;  CTRL A-Z 
;;; ==========
CTRL-A 
CTRL-B 
CTRL-C 
CTRL-D 
CTRL-E 
CTRL-F 
CTRL-G 
CTRL-H 
CTRL-I 
CTRL-J 
CTRL-K 
CTRL-L 
CTRL-M 
CTRL-N 
CTRL-O 
CTRL-P 
CTRL-Q 
CTRL-R 
CTRL-S 
CTRL-T 
CTRL-U 
CTRL-V 
CTRL-W 
CTRL-X 
CTRL-Y 
CTRL-Z 
CTRL-2 
CTRL-6 
CTRL-- 
CTRL-BkSp 
CTRL-[ 
CTRL-] 
CTRL-Enter 
CTRL-\ 
CTRL-PrtSc 
CTRL-Home 
CTRL-PgUp 
CTRL-Left 
CTRL-Right 
CTRL-End 
CTRL-PgDn 
;;; ============
;;;  Other Keys 
;;; ============
Home 
Up 
PgUp <SProtocols_>
GreyMinus 
Left 
Right 
GreyPlus 
End 
Down 
PgDn <RProtocols_>
Ins 
Del 
;;; =========
;;;  Fn Keys 
;;; =========
F1 <SendStr>[USER_NAME]^M
F2 <SendStr>[FON_PWD]^M
F3 <SendStr>[LOCATION]^M
F4 <SendStr>[FON_ID]^M
F5 <RunProg>COMMAND /C sendfax %PF %DN %WK
F6 <SendStr>AT+FDR^M
F7 <SendAscii>%PF 
F8 <Users>
F9 <HelpMenu>
F10 <TopBar>
F11 <ChgDir>\QWK <RunProg>OFFLINE <ChgDir>[DIR_START]
F12 <SendStr>[FON_ID]
SHIFT-F1 <SendStr>ACE20A.ZIP
SHIFT-F2 <SendStr>ACE20B.ZIP
SHIFT-F3 <SendStr>AceComm Communications Package version 2.0
SHIFT-F4 <SendStr>Inovative and feature full COMM package especialy
SHIFT-F5 <SendStr>for Hi-Speed modems. Macro language, key-redef
SHIFT-F6 <SendStr>USBBS115.ZIP
SHIFT-F7 
SHIFT-F8 
SHIFT-F9 
SHIFT-F10 
SHIFT-F11 
SHIFT-F12 
CTRL-F1 <LocalEcho> ON <DIALNUM> 846-2940 <LocalEcho> OFF
CTRL-F2 <SetDTR> Off <Delay> 5 <SetDTR> ON
CTRL-F3 
CTRL-F4 
CTRL-F5 
CTRL-F6 
CTRL-F7 
CTRL-F8 
CTRL-F9 
CTRL-F10 
CTRL-F11 
CTRL-F12 
ALT-F1 
ALT-F2 <LogFile>This is a test line by [USER_NAME]
ALT-F3 <DispStr>^M^JHello    [CBW][CBW][CBW]Hello^M^J
ALT-F4 
ALT-F5 
ALT-F6 
ALT-F7 
ALT-F8 
ALT-F9 <SetUser>1
ALT-F10 <SetUser>2
ALT-F11 <SetUser>3
ALT-F12 <PollHost>1 files ![USER_NAME]

