unit hexdump;
interface
function byte_to_hex (b: byte): string;
function int_to_hex (i: integer): string;
function word_to_hex (i: word): string;
function char_to_hex (c: char): string;
function hex(b: byte): string;
function hexw(w: word): string;
function hexc(c: char): string;
function hexl(l: longint): string;
function hexbytes(var v; size: byte): string;
type wordrec = record
                 lo: byte;
                 hi: byte;
               end;
     longrec = record
                 loword: word;
                 hiword: word;
               end;
implementation
const hexdig: array[0..15] of char = '0123456789ABCDEF';
function hex;
var n1,n2: 0..15;
begin
   n1 := b shr 4;
   n2 := b and $0F;
   hex := hexdig[n1] + hexdig[n2];
end;
function hexc;
begin
  hexc := hex(byte(c));
end;

function byte_to_hex (b: byte): string;
var n1,n2: 0..15;
begin
   n1 := b shr 4;
   n2 := b and $0F;
   byte_to_hex := hexdig[n1] + hexdig[n2];
end;
function char_to_hex (c: char): string;
begin
  char_to_hex := byte_to_hex (byte(c));
end;
function int_to_hex (i: integer): string;
begin
  int_to_hex := byte_to_hex (hi(i)) + byte_to_hex (lo(i));
end;
function hexw (w: word): string;
begin
   hexw := byte_to_hex (hi(w)) + byte_to_hex (lo(w));
end;
function word_to_hex;
begin
   word_to_hex := hexw(i);
end;
function hexl(l: longint): string;
var lx: longint;
    lbyte: array[1..4] of byte absolute lx;
begin
   lx := l;
   hexl := hex(lbyte[4]) + hex(lbyte[3]) + hex(lbyte[2]) + hex(lbyte[1]);
end;
function hexbytes(var v; size: byte): string;
    type b127= array[1..127] of byte;
var p: ^b127;
    s: string[255];
    i,j: integer;
begin
  p := @v;
  s := '';
  for i:= 1 to size do begin
     s:=s+hex(p^[i]);
  end;
  hexbytes := s;
end;

end.