
/* AiClock.c - Compiled with BorlandC compiler, small model. */
/* Copyright (c) 1995 J.A.Roeckelein */

#include <Time.h>
#include <ConIO.h>
#include <DOS.h>
#include <String.h>

#define YEAR            (coarse->tm_year+1900)
#define YDAY            (coarse->tm_yday)
#define MNTH            (coarse->tm_mon+1)
#define MDAY            (coarse->tm_mday)
#define WDAY            (coarse->tm_wday+1)
#define HOUR            (fine.ti_hour)
#define MINS            (fine.ti_min)
#define SECS            (fine.ti_sec)
#define HUND            (fine.ti_hund)

#define TIMES2(x)       ((x)<<1)
#define TIMES160(x)     (((x)<<7)+((x)<<5))

#define YEAR_STUFF      YEAR,4,18,5,4,12,10,8
#define YDAY_STUFF      YDAY,6,15,7,6,9,12,4
#define MNTH_STUFF      MNTH,8,14,16,15,4,10,8
#define MDAY_STUFF      MDAY,10,18,12,11,5,10,8
#define WDAY_STUFF      WDAY,12,15,21,20,3,12,4
#define HOUR_STUFF      HOUR,16,13,13,12,5,14,6
#define MINS_STUFF      MINS,18,12,11,10,6,14,6
#define SECS_STUFF      SECS,20,12,11,10,6,14,6
#define HUND_STUFF      HUND,22,15,9,8,7,13,5

#define PLOTBAR(r,c,blen,clr)                                           \
	at = screen + TIMES160(r) + TIMES2(c);                          \
	for ( i=0; i<blen; i++ ) {                                      \
		at++;                                                   \
		*at++ = clr;                                            \
	}                                                               
	
char far 	*screen;
char far 	*at;

void PlotVal(int dat,int r1,int c1,int inc,int len,int bits,int fg,int bg) 
{                                                                       
	int             i,col,bit;

	col = c1;                                                       
	for ( bit=(1<<(bits-1)); bit>0; bit>>=1 ) {                     
		if ( dat & bit ) {                                       
			PLOTBAR(r1,col,len,fg);                          
		} else {
			PLOTBAR(r1,col,len,bg);                          
		}
		col += inc;                                             
	}                                                               
}

void main(void) 
{
	/*
	 * ClockFace is a 4000 byte array stored in an OBJ file.  It got 
	 *  there via a program called BIN2OBJ that I found somewhere which
	 *  converts binary files into OBJ files.  The actual binary file
	 *  was generated by merging two binary images created with TheDraw 
	 *  into a single image (TheDraw allows up to 23 rows per image, so
	 *  I drew 23 rows in the first image, then the last two rows in the
	 *  second image).  The two images were merged into one with the
	 *  quick'n dirty little program MKCLKFAC.C. 
	 */
	extern char     ClockFace[4000];

	struct time     fine;
	struct tm       *coarse;
	time_t          secs;
	unsigned char	hunds;

	/* form pointer to start of (assumed text mode 3) video memory */
	screen = (char far *)MK_FP(0xb800,0);

	/* remove the cursor */
	_setcursortype(_NOCURSOR);

	/* copy the clock face image to the screen */
	_fmemcpy(screen,ClockFace,4000);

	/* get current date and time */
	gettime(&fine);
	hunds = HUND;
	secs = time(NULL);
	coarse = localtime(&secs);

	/* display all stuff */
	PlotVal(YEAR_STUFF);
	PlotVal(YDAY_STUFF);
	PlotVal(MNTH_STUFF);
	PlotVal(MDAY_STUFF);
	PlotVal(WDAY_STUFF);
	PlotVal(HOUR_STUFF);
	PlotVal(MINS_STUFF);
	PlotVal(SECS_STUFF);
	PlotVal(HUND_STUFF);

	do {
		/* read the time now */
		gettime(&fine);

		/* update each fine-valued binary display */
		if ( hunds == HUND ) continue;
		hunds = HUND;
		PlotVal(HUND_STUFF);
		PlotVal(SECS_STUFF);
		if ( SECS != 0 ) continue;              
		PlotVal(MINS_STUFF);
		if ( MINS != 0 ) continue;
		PlotVal(HOUR_STUFF);
		if ( HOUR != 0 ) continue;
		
		/* read the date now */
		secs = time(NULL);
		coarse = localtime(&secs);

		/* update each coarse-valued binary display */
		PlotVal(WDAY_STUFF);
		PlotVal(MDAY_STUFF);
		PlotVal(YDAY_STUFF);
		if ( MDAY != 1 ) continue;
		PlotVal(MNTH_STUFF);
		if ( MNTH != 1 ) continue;
		PlotVal(YEAR_STUFF);

	} while ( !kbhit() );
	getch();

	/* clear the screen */
	clrscr();
	_setcursortype(_NORMALCURSOR);
}

/* end of file */

