; File......: CHDIR.ASM
; Author....: Ted Means
; Date......: $Date:   15 Aug 1991 23:07:20  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/chdir.asv  $
; 
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/chdir.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:07:20   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:20   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:10   GLENN
;  Nanforum Toolkit
;  
;


;  $DOC$
;  $FUNCNAME$
;     FT_CHDIR()
;  $CATEGORY$
;     DOS/BIOS
;  $ONELINER$
;     Change the current directory
;  $SYNTAX$
;     FT_CHDIR( <cDirName> ) -> nResult
;  $ARGUMENTS$
;     <cDirName> is the name of the desired directory.
;  $RETURNS$
;     0  if successful
;     3  if path not found
;     99 if invalid parameters passed
;  $DESCRIPTION$
;     Use this function if you prefer to change the active directory
;     instead of relying on the SET PATH command.
;
;     The source code is written to adhere to Turbo Assembler's IDEAL mode.
;     To use another assembler, you will need to rearrange the PROC and
;     SEGMENT directives, and also the ENDP and ENDS directives (a very
;     minor task).
;  $EXAMPLES$
;     FT_CHDIR( "C:\CLIPPER" )
;     FT_CHDIR( "\" )
;     FT_CHDIR( "..\SOURCE" )
;  $END$
;

         IDEAL

Public   FT_CHDIR

Extrn    __ftdir:Far

Segment  _NanFor   Word      Public    "CODE"
         Assume    CS:_NanFor

Proc     FT_CHDIR  Far

         Mov       AH,3Bh                    ; DOS service -- change directory
         Push      AX                        ; Save on stack
         Call      __ftdir                   ; Call generic directory routine
         Add       SP,2                      ; Realign stack
         Ret
Endp     FT_CHDIR
Ends     _NanFor
End

