* Program: Horimenu.prg
* Author:  Don L. Powells
* Version: Clipper Summer '87
* Note(s): Demonstrates horizontal light-bar movement with
*          SET KEY, @..PROMPT and MENU TO.
*
*          The left and right arrow keys are set to functions
*          which stuff the keyboard with the number of arrow
*          keys equal to the height of a menu column.
*
* Copyright (c) 1989 Nantucket Corporation.

* Display screen constants.
CLEAR SCREEN
@ 1,15 SAY " Testing Menu w/ Horizontal Movement"
@ 3,23 TO 9,42
@ 11,15 SAY " Press <ESC> to exit this program. "

* Assign right and left arrow keys to user-defined functions.
SET KEY 4 TO Rtarrow
SET KEY 19 TO Ltarrow

* Show menu.
SET WRAP ON
choice = 1
DO WHILE choice != 0
   @ 5,25 PROMPT "Opt 1"
   @ 6,25 PROMPT "Opt 2"
   @ 7,25 PROMPT "Opt 3"
   @ 5,35 PROMPT "Opt 4"
   @ 6,35 PROMPT "Opt 5"
   @ 7,35 PROMPT "Opt 6"
   MENU TO choice

   @ 13,5
   @ 13,5 SAY "Option " + LTRIM(STR(choice)) + " was chosen."
   WAIT
   @ 13,5
   @ 14,0
ENDDO
RETURN

* Rtarrow()
* Stuffs the keyboard with three down arrows when the right arrow
* key is pressed.
*
FUNCTION Rtarrow
KEYBOARD REPLICATE(CHR(24),3)
RETURN(.T.)


* Ltarrow()
* Stuffs the keyboard with three up arrows when the left arrow key
* is pressed.
*
FUNCTION Ltarrow
KEYBOARD REPLICATE(CHR(5),3)
RETURN(.T.)

* EOF: Horimenu.prg
