* Function PR_OK  : Allows graceful pausing/termination of reports.
* Author          : N. Weicher, Communication Horizons.
* Date            : 11/86.
* Input parameters: none.
* Return value (L): .T. = continue report, .F. = cancel report.
* Description      : see notes in associated article

FUNCTION PR_OK
PRIVATE M_REQUEST, M_CONTINUE
M_CONTINUE = .T.                        && assume printing will continue
IF INKEY() = 27                         && escape key pressed
  SET CONFIRM OFF
  M_REQUEST = 0
  @ 24,0 SAY [Printing paused.  0=quit, 1=resume, 2=backup 1 page & resume:] ;
             GET M_REQUEST PICTURE "9" RANGE 0,2

  SET ESCAPE OFF			&& so Esc bangers don't dump to DOS
  READ
  SET ESCAPE ON

  @ 24,0 CLEAR
  DO CASE
  CASE M_REQUEST = 0                    && cancel report
    M_CONTINUE = .F.                    && necessary to stop report

  CASE M_REQUEST = 1                    && resume report
    M_CONTINUE = .T.

  CASE M_REQUEST = 2                    && backup 20 records, eject page;
    SKIP -20				&& tailor this to where/however
    EJECT				&& you prefer it to back up
    M_CONTINUE = .T.

  ENDCASE
ENDIF
RETURN (M_CONTINUE)

* EOS
