Version 1.00
BEGIN Form frmGramMole
	AutoRedraw   = 0
	BackColor    = QBColor(7)
	BorderStyle  = 2
	Caption      = "M.M. = g / moles "
	ControlBox   = -1
	Enabled      = -1
	ForeColor    = QBColor(0)
	Height       = Char(6)
	Left         = Char(0)
	MaxButton    = -1
	MinButton    = -1
	MousePointer = 0
	Tag          = ""
	Top          = Char(2)
	Visible      = 0
	Width        = Char(79)
	WindowState  = 0
	BEGIN Label lblDivisionLine
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(27)
		MousePointer = 0
		TabIndex     = 6
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(25)
	END
	BEGIN Label lblX
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "X"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(51)
		MousePointer = 0
		TabIndex     = 7
		Tag          = ""
		Top          = Char(0)
		Visible      = 0
		Width        = Char(1)
	END
	BEGIN Label lblDragDrop
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(8)
		BorderStyle  = 0
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(27)
		MousePointer = 0
		TabIndex     = 9
		Tag          = ""
		Top          = Char(3)
		Visible      = 0
		Width        = Char(24)
	END
	BEGIN Label lblEqualSign
		Alignment    = 2
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "="
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Left         = Char(25)
		MousePointer = 0
		TabIndex     = 10
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(1)
	END
	BEGIN CommandButton cmdSize
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Size"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(2)
		Left         = Char(0)
		MousePointer = 0
		TabIndex     = 14
		TabStop      = -1
		Tag          = "2"
		Top          = Char(2)
		Visible      = -1
		Width        = Char(6)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(24)
		MousePointer = 0
		TabIndex     = 11
		TabStop      = 0
		Tag          = ""
		Top          = Char(0)
		Value        = 0
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(3)
		Height       = Char(1)
		Index        = 1
		Left         = Char(24)
		MousePointer = 0
		TabIndex     = 12
		TabStop      = 0
		Tag          = ""
		Top          = Char(1)
		Value        = 0
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN OptionButton optDependent
		BackColor    = QBColor(7)
		Caption      = ""
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(24)
		MousePointer = 0
		TabIndex     = 13
		TabStop      = -1
		Tag          = ""
		Top          = Char(2)
		Value        = -1
		Visible      = 0
		Width        = Char(3)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(7)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(0)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 1
		TabStop      = -1
		Tag          = "amount"
		Text         = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(27)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 3
		TabStop      = -1
		Tag          = "mass"
		Text         = ""
		Top          = Char(0)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN TextBox txtVariable
		BackColor    = QBColor(3)
		BorderStyle  = 0
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(27)
		MousePointer = 0
		MultiLine    = 0
		ScrollBars   = 0
		TabIndex     = 5
		TabStop      = -1
		Tag          = "molar mass"
		Text         = ""
		Top          = Char(2)
		Visible      = -1
		Width        = Char(19)
	END
	BEGIN CommandButton cmdUpdate
		BackColor    = QBColor(7)
		Cancel       = 0
		Caption      = "&Update molar mass"
		Default      = 0
		DragMode     = 0
		Enabled      = -1
		Height       = Char(3)
		Left         = Char(55)
		MousePointer = 0
		TabIndex     = 8
		TabStop      = -1
		Tag          = ""
		Top          = Char(1)
		Visible      = -1
		Width        = Char(20)
	END
	BEGIN Label lblVariable
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "m&ol"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 3
		Left         = Char(19)
		MousePointer = 0
		TabIndex     = 0
		Tag          = "0"
		Top          = Char(1)
		Visible      = -1
		Width        = Char(5)
	END
	BEGIN Label lblVariable
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "&g"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 2
		Left         = Char(46)
		MousePointer = 0
		TabIndex     = 2
		Tag          = "1"
		Top          = Char(0)
		Visible      = -1
		Width        = Char(5)
	END
	BEGIN Label lblVariable
		Alignment    = 0
		AutoSize     = 0
		BackColor    = QBColor(7)
		BorderStyle  = 0
		Caption      = "g&/mol"
		DragMode     = 0
		Enabled      = -1
		ForeColor    = QBColor(0)
		Height       = Char(1)
		Index        = 1
		Left         = Char(46)
		MousePointer = 0
		TabIndex     = 4
		Tag          = "4"
		Top          = Char(2)
		Visible      = -1
		Width        = Char(5)
	END
END
' Updated:  October, 1996 by Christopher King
'
' ------------------------------------------------------------------------
'               Copyright (C) 1996 by Christopher King
'
' You have a royalty-free right to use, modify, reproduce and distribute
' the OneOhOne Files (and/or any modified version) in any way you find
' useful, provided that you agree that Christopher King has no warranty,
' obligations or liability for any OneOhOne Files.
' ------------------------------------------------------------------------
DECLARE SUB cmdUpdate_Click ()
DECLARE FUNCTION bAnalyzeInput (BYVAL sText AS STRING, dNumber AS DOUBLE, dError AS DOUBLE) AS INTEGER
DECLARE SUB Disconnect (BYVAL nvIndex%)
'$FORM frmMdi
DECLARE FUNCTION nSetNextFocus (BYVAL nvIndex%) AS INTEGER
DECLARE SUB DragDrop3 (Source AS CONTROL, X AS SINGLE, Y AS SINGLE, BYVAL sSize AS STRING, BYVAL nvGroup%, Target AS FORM)
DECLARE SUB FormPositionClear (BYVAL nvGroup%)
DECLARE SUB SizeForm (BYVAL svSizeStatus AS STRING, BYVAL nvGroup%, CallingForm AS FORM)
DECLARE FUNCTION nOptionButton (Index%, BYVAL nvGroup%, CallingForm AS FORM) AS INTEGER
DECLARE SUB Form_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
DECLARE FUNCTION nGroupOfIndex (BYVAL Index AS INTEGER) AS INTEGER
DECLARE SUB InterpretKeyPress (BYVAL Index%, KeyAscii%, nvGroup%, CallingForm AS FORM)
DECLARE SUB GeneralLostFocus (BYVAL Index%, BYVAL nvGroup%, CallingForm AS FORM)
DECLARE SUB fraGramMole_DragDrop (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
DECLARE SUB optDependent_Click (Index AS INTEGER)
DECLARE SUB txtVariable_GotFocus (Index AS INTEGER)
DECLARE SUB txtVariable_LostFocus (Index AS INTEGER)
'$FORM frmMolarMass
OPTION EXPLICIT
DEFINT A-Z
					  
'$INCLUDE: 'common.bi'

CONST YELLOW = 14

' Change the size of the frame and placement of controls in frame.
SUB cmdSize_Click ()
'  nSizeGramMoleFrame can be  1 for medium
'                             2 for large
' The previous size is stored in this contol's tag.

SizeForm cmdSize.Tag, 1, frmGramMole
SELECT CASE cmdSize.Tag
	CASE "1"
		cmdUpdate.Top = 3
		cmdUpdate.Left = 6
	CASE "2"
		cmdUpdate.Top = 1
		cmdUpdate.Left = 55
END SELECT

END SUB

DEFSNG A-Z
'  Places the current molar mass from frmMolarMass in the molar mass
'  text box on frmGramMole.
SUB cmdUpdate_Click ()
	DIM N

	IF NOT frmMdi.mnuWindowForm(0).Checked THEN
		N = nSetNextFocus(1) ' Don't leave with focus on command button.
		frmMolarMass.SHOW
	ELSE
		IF frmMolarMass.cmdPrint.Tag = "" THEN
			N = nSetNextFocus(1)
			frmMolarMass.SHOW
			IF frmMolarMass.WindowState = 1 THEN frmMolarMass.WindowState = 0
		ELSE
			' Get the molar mass string from frmMolarMass.
			IF gnConnected(1) THEN Disconnect 1
			txtVariable(1).Text = frmMolarMass.cmdPrint.Tag
			txtVariable_LostFocus (1) ' Calculate values.
			N = nSetNextFocus(1)
		END IF
	END IF
END SUB

DEFINT A-Z
'
' Called by lblDragDrop_Change, lblVariable_DragDrop, txtVariable_DragDrop,
' and by user action.
SUB Form_DragDrop (Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
	DragDrop3 Source, X, Y, cmdSize.Tag, 1, frmGramMole
END SUB

DEFSNG A-Z
SUB Form_Load ()
	' gOccupantIndex keeps track of which of the three txtGramMole's, and
	' lblGramMole's, is in each position.  The index of the occupants
	' initially is:
	gOccupantIndex(1, 0) = 3  ' Meaning position 0 is occupied by txtVariable(3).
	gOccupantIndex(1, 1) = 2
	gOccupantIndex(1, 2) = -1 ' -1 means empty
	gOccupantIndex(1, 4) = 1
	frmMdi.mnuWindowForm(1).Checked = TRUE
END SUB

DEFINT A-Z
' Free the location of this form.
SUB Form_Unload (Cancel AS INTEGER)
FormPositionClear 1
END SUB

' Moves the last variable on the form that had the focus to specified location.
' Menu move entries call this procedure.
SUB lblDragDrop_Change ()
DIM Index
	Index = VAL(frmGramMole.Tag)
	SELECT CASE lblDragDrop.Caption  ' Unspecified caption gives form's caption.
		' Moving control location on form.
		CASE "M0"
			lblDragDrop.Tag = STR$(Index) + " 1" + txtVariable(Index).Tag
			Form_DragDrop lblDragDrop, 0!, 1!
		CASE "M1"
			lblDragDrop.Tag = STR$(Index) + " 1" + txtVariable(Index).Tag
			Form_DragDrop lblDragDrop, 26!, 0!
		CASE "M2", "M3"
			lblDragDrop.Tag = STR$(Index) + " 1" + txtVariable(Index).Tag
			Form_DragDrop lblDragDrop, 52!, 0!
		CASE "M4", "M5", "M6"
			lblDragDrop.Tag = STR$(Index) + " 1" + txtVariable(Index).Tag
			Form_DragDrop lblDragDrop, 26!, 2!

		CASE "OB"
			' Click an option button for a different module.
			' The tag tells which one.
			optDependent_Click (VAL(lblDragDrop.Tag))
	END SELECT
	lblDragDrop.Caption = ""
END SUB

SUB lblVariable_DragDrop (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
	Form_DragDrop Source, CSNG(lblVariable(Index).Left), CSNG(lblVariable(Index).Top)
END SUB

' left button pressed         initiate drag
' right button pressed        update molar mass
'
' The label's tag is given txtGramMole's index.
SUB lblVariable_MouseDown (Index AS INTEGER, Button AS INTEGER, Shift AS INTEGER, X AS SINGLE, Y AS SINGLE)
IF Button = 2 THEN
	' Right button was pressed.  If on molar mass, update, if valid formula.
	IF Index = 1 AND cmdUpdate.Enabled THEN
		cmdUpdate_Click
	END IF
ELSE
	' Allow only the dependent variable to be dragged when the frame is small.
	IF Index <> gOccupantIndex(1, 0) AND cmdSize.Tag = "1" THEN EXIT SUB
	txtVariable(Index).SETFOCUS
	lblDragDrop.Tag = STR$(Index) + " 1" + txtVariable(Index).Tag
	lblDragDrop.MOVE lblVariable(Index).Left - 19, lblVariable(Index).Top + Y, 24, 1
	lblDragDrop.DRAG        ' Drag label outline
END IF

END SUB

' Selects the dependent variable:  molar mass, grams, or moles.
' Index is the txtGramMole index of the dependent variable.
SUB optDependent_Click (Index AS INTEGER)
DIM N

	' Enable the Update button
	cmdUpdate.Enabled = NOT (Index = 0)
	N = nOptionButton(Index, 1, frmGramMole)
	IF N > 0 AND N < 4 THEN
		' I don't know why.  The SetNextFocus routine works for other forms,
		' but not this one.
		txtVariable_GotFocus N    ' Color yellow, etc.
		txtVariable(N).SETFOCUS   ' First one does nothing if already there.
	END IF

END SUB

SUB txtVariable_DragDrop (Index AS INTEGER, Source AS CONTROL, X AS SINGLE, Y AS SINGLE)
	Form_DragDrop Source, CSNG(txtVariable(Index).Left), CSNG(txtVariable(Index).Top)

END SUB

' Stores to index of the current txtGramMole in the frame's tag.
SUB txtVariable_GotFocus (Index AS INTEGER)

	IF NOT gbDontStopHere(Index) THEN
		' NonContinuedLine indicates whether or not the selection is to be
		' deleted by the first key pressed.
		txtVariable(Index).BackColor = YELLOW
		txtVariable(Index).SelStart = 0
		txtVariable(Index).SelLength = 19
		gsOriginalText(1) = txtVariable(Index).Text ' Save original text; recall with escape key.
	END IF
	frmGramMole.Tag = STR$(Index)

END SUB

SUB txtVariable_KeyPress (Index AS INTEGER, KeyAscii AS INTEGER)
	InterpretKeyPress Index, KeyAscii, 1, frmGramMole
END SUB

SUB txtVariable_LostFocus (Index AS INTEGER)
	' Do the calculations for grams, moles, and molar mass.
	GeneralLostFocus Index, 1, frmGramMole

END SUB

