
;============================================================================
;
; FINDFIRST.ASM
; DOS old 'find first' function (int 21h, function 11h)
; This file is part of the
;
; PseudoCD package (version 02)
; Copyright (C) 1997  C.Kulms
;
;   This is free software; you can redistribute it and/or modify it
;   under the terms of the GNU General Public License as published by
;   the Free Software Foundation; version 2 of the License.
;
;   This software is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this software; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;============================================================================*/

IDEAL
P386
LOCALS @@

MODEL SMALL
CODESEG

PUBLIC _DOS_FindFirstByFCB

PROC _DOS_FindFirstByFCB
; gets an extended directory entry for a file given by a FCB
; prototype: int DOS_FindFirstByFCB( struct fcb far *fpsFCB )
; return: 1 if successfull, 0 else
	ARG fpsFCB:DWORD

	push	bp				;setup stack
	mov		bp,sp
	push	ds				;save ds
	push	dx              ;save dx

	lds		dx,[fpsFCB]		;ds:dx->FCB
	mov		ah,11h
	int		21h
	not		al				;al=00h on success, 0FFh on error
	mov		ah,al

	pop		dx				;restore dx
	pop		ds				;restore ds
	pop		bp				;restore stack
	ret

ENDP _DOS_FindFirstByFCB

END ;of file 'FINDFIRS.ASM'

