/*
==============================================================================
                      WordUp Graphics Toolkit Version 5.0                     
                             Demonstration Program 44                         
                                                                              
 Displays the status of the keyboard flags.  Try pressing the numlock,       
 scrlock, capslock, shift, ctrl and alt keys.                                
                                                                              
 Once a key other than those listed above is hit, it then flashes the        
 keyboard LEDS in sequence.                                                  
                                                                              
 *** PROJECT ***                                                             
 This program requires the WGT5_WC.LIB file to be linked.                    
                                                                              
 *** DATA FILES ***                                                          
 None.                                                                       
                                                           WATCOM C++ VERSION 
==============================================================================
*/

#include <wgt5.h>

void main(void)
{
  printf ("WGT Example #44\n\n");
  printf ("Control of the keyboard status keys is demonstrated.\n");
  printf ("Press a key to abort key detection and force keys to be lighted.\n");
  printf ("Another keypress will end the program.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

   wsetmode (3);
   do {
     if (wget_numlock ())  
       printf ("NUMLOCK  ");
     if (wget_capslock ()) 
       printf ("CAPSLOCK  ");
     if (wget_scrlock ())  
       printf ("SCRLOCK  ");
     if (wget_lshift ())   
       printf ("LSHIFT  ");
     if (wget_rshift ())   
       printf ("RSHIFT  ");
     if (wget_lalt ())     
       printf ("LALT  ");
     if (wget_ralt ())     
       printf ("RALT  ");
     if (wget_lctrl ())     
       printf ("LCTRL  ");
     if (wget_rctrl ())     
       printf ("RCTRL  ");
     printf ("\n");
   } while (!kbhit ());

   getch ();

   wset_numlock (0);
   wset_capslock (0);
   wset_scrlock (0);
   do {
     wset_numlock (1); /* For some reason, this must be done twice ? */
     delay (100); 
     wset_numlock (1); 
     delay (100); 
     wset_numlock (0); 
     delay (100); 
     wset_capslock (1); 
     delay (100); 
     wset_capslock (0);
     delay (100);
     wset_scrlock (1); 
     delay (100); 
     wset_scrlock (0);
     delay (100);
   } while (!kbhit ());
   getch ();

   wset_numlock (1);
   wset_capslock (0);
   wset_scrlock (0);
}
