/*
==============================================================================
		      WordUp Graphics Toolkit Version 4.5
			     Demonstration Program 64

 This is a picture viewer for PCX, IFF and LBM images. All images
 are displayed using 320x200x256.  Images that are bigger than 320x200
 are not supported (due to the segment limitation)

 The image filename must be passed on the command line.

 *** PROJECT ***                                                             
 This program needs the WGT45.LIB file to be linked.
                                                                              
 *** DATA FILES ***                                                          
 Any PCX, IFF or LBM format pictures.                                   
                                                           WATCOM C++ VERSION 
==============================================================================
*/
#include <wgt45.h>
#include <stdio.h>
#include <dir.h>
#include <stdlib.h>

color pal[256];
block bigpic;

void main (int argc, char *argv[])
{
short oldmode;
short vx, vy, sx, sy, ox, oy;
short w, h;
char *pathbuf;
char drive[MAXDRIVE];
char dir[MAXDIR];
char fname[MAXFILE];
char ext[MAXEXT];

  oldmode = wgetmode ();
  if (argc < 2) 
  {
    printf ("WGT Example #64\n\n");
    printf ("This program displays a picture and allows you to slide\n");
    printf ("around with the mouse.\n");
    printf ("\nUsage: WGT64 filename\n\n");
    printf ("Where filename is a PCX, IFF or LBM image file format.\n");
    exit (0);
  }
  vga256 ();
  
  vx = vy = 0;
  
  pathbuf = argv[1];
  fnsplit (pathbuf, &drive, &dir, &fname, &ext);
  
  
  /* Find out what kind of picture it is and load the image */
  if (strcmp (ext, ".pcx") == 0)
    bigpic = wloadpcx (argv[1], pal);
  else if ((strcmp (ext, ".iff") == 0) || (strcmp (ext, ".lbm") == 0))
    bigpic = wloadiff (argv[1], pal);
  
  if (bigpic != NULL)
  {
    wsetmode (3);
    w = wgetblockwidth (bigpic);        /* Inform user of loaded data */
    h = wgetblockheight (bigpic);
    printf ("Image is %d by %d pixels.\n", w, h);
    printf ("%lu bytes.\n\n\n", (long)w*(long)h);
    getch ();
    vga256 ();
    wsetpalette (0, 255, pal);
    wputblock (vx, vy, bigpic, NORMAL);
    minit ();
    mon ();
    while (!kbhit ())                   /* Now let user scroll around */
    {
      if (but > 0)
      {
	sx = mx;
	sy = my;
	ox = vx;
	oy = vy;
	moff ();
	while (but > 0)
	{
	  ox = vx - (sx - mx);
	  oy = vy - (sy - my);
	  if (ox + w < 320)
	    ox = 320 - w;
	  if (oy + h < 200)
	    oy = 200 - h;
	  if (ox > 0)
            ox = 0;
          if (oy > 0)
            oy = 0;

          wputblock (ox, oy, bigpic, NORMAL);
        }
        vx = ox;
        vy = oy;
        mon ();
      }
    }
    getch ();
    wfreeblock (bigpic);
    moff ();
    mdeinit ();
    wfade_out (0, 255, 20, pal);
  }
  wsetmode (oldmode);
}
