/*
ͻ
                     WordUp Graphics Toolkit Version 4.5                    
                            Demonstration Program 21                        
                                                                            
 Shows off some special FX using wvertres.                                  
                                                                            
  PROJECT                                                             
 This program requires the file WGT45.LIB to be linked.          	     
                                                                            
  DATA FILES                                                          
 Make sure that WGT1.BLK, WGT2.BLK and WGT1.PAL are in your executable dir. 
                                                                            
ͼ
*/

#include <conio.h>
#include <stdio.h>
#include <wgt45.h>

void crush (block, block, int);

block screen1, screen2;		/* two virtual screens */

int oldmode;
int y, s;
color palette[256];

void main(void)
{
  printf ("WGT Example #21\n\n");
  printf ("This program will repeatedly crush two screens until a key is pressed.\n");
  printf ("\n\nPress any key to continue.\n");
  getch ();

  if (!vgadetected ())
    {
     printf ("Error - VGA card required for any WGT program.\n");
     exit (0);
    }

  oldmode = wgetmode ();
  vga256 ();

  screen1 = wloadblock ("wgt1.blk");
  screen2 = wloadblock ("wgt2.blk");
  wloadpalette ("wgt1.pal", palette);
  wsetpalette (0, 255, palette);
  wputblock (0, 0, screen1, 0);

  do {
    wretrace ();
    crush (screen1, screen2, 2);
    crush (screen2, screen1, 2);
  } while (!kbhit ());

  wfreeblock (screen1);	/* remember to free that memory */
  wfreeblock (screen2);
  wsetmode (oldmode);
}


void crush (block b1, block b2, int dir)
{
  int q, w, e;

  for (q = 199; q >= 0; q -= dir)
    {
     wvertres (0, 0, q, b1);
     wvertres (0, q, 199, b2);
    }
}
