;Extreme Vigourous memory manage tests

.data
  full db 0
  hi _heapinfo <>
  f dd ?  ;FILE *

.data?

  noe equ (512)  ;No of entries

  hnds dd noe dup (?)   ;4k each
  sizs dd noe dup (?)

  MAXRAM equ (1024*4)
  REQRAM equ (noe * MAXRAM *2)  ;*2 just in case
  MINRAM equ (1)

  _ALLOC equ 16  ;# of entries to alloc each time
  _FREE equ 4    ;# of entries to free each time (must be less than _ALLOC)

.code

memtest_init proc
  callp coreleft
  mov ebx,eax
  .if ebx < REQRAM
    callp printf,"Insufficent memory for memory tests...\n"
    callp printf,"Require at least %d.",REQRAM*2  ;*2 cause of memory holes
    callp printf,"You have %d.\n",ebx
    callp exit,0
  .endif
  xor eax,eax
  mov ecx,(sizeof hnds)/4
  mov edi,offset hnds
  rep stosd
  mov eax,ds:[46ch]  ;timer
  callp srand,eax  ;Reseed random # generator

  callp gotoxy,30,1
  callp printf,"Stage #1 : Filling memory tables."

  ret
memtest_init endp

memtest proc
  ;go thru hnds table and add new malloc's()
  mov ecx,noe
  mov edx,_ALLOC
  mov esi,offset hnds
  mov edi,offset sizs
@@:
  cmp dptr[esi],NULL
  .if zero?
    callp rand
    .if eax > MAXRAM
      mov eax,MAXRAM
    .endif
    .if eax < MINRAM
      mov eax,MINRAM
    .endif
    mov [edi],eax
    callp malloc,eax
    cmp eax,NULL
    je noRAM
    mov [esi],eax
    dec edx
  .endif
  test edx,edx
  jz done1
  add esi,4
  add edi,4
  dec ecx
  jnz @b

  .if !full
    callp gotoxy,30,1
    callp printf,"Stage #2 : Tables full, continuing normal tests."
    mov full,1
  .endif

done1:
  ;go thru and realloc() every block
  mov ecx,noe
  mov esi,offset hnds
  mov edi,offset sizs
@@:
  .if dptr[esi]!=NULL
    mov ebx,[edi]
    callp rand
    and eax,0fffh
    .if eax & 1
      add ebx,eax
    .else
      sub ebx,eax
    .endif
    .if ebx > MAXRAM
      mov ebx,MAXRAM
    .endif
    .if ebx < MINRAM
      mov ebx,MINRAM
    .endif
    callp realloc,dptr[esi],ebx
    cmp eax,NULL
    je noRAM
    mov [esi],eax
    mov [edi],ebx
  .endif
  add esi,4
  add edi,4
  dec ecx
  jnz @b

done2:
  ; Now free random entries
  mov ecx,_FREE
@@:
  callp rand
  .if eax >= noe
    jmp @b
  .endif
  shl eax,2
  mov esi,offset hnds
  add esi,eax
  .if dptr[esi]!=NULL
    callp free,dptr[esi]
    mov dptr[esi],NULL
  .endif
  dec ecx
  jnz @b

done3:

  call showram

  ret

noRAM:
  db 16 dup (90h)
  mov edx,"Ran out of memory!"
  jmp failed
memtest endp

showram proc
  pushad
  callp gotoxy,1,10
  callp _memtotal
  callp printf," Total memory=%d    \n",eax
  callp _memavl
  callp printf,"   Total free=%d    \n",eax
  callp _memmax
  callp printf," Largest free=%d    \n",eax
  callp _memused
  callp printf,"  Used memory=%d    \n",eax
  callp _heapfrag
  .if errno==ECONTR
    mov edx,"Fragmentation"
    jmp failed
  .endif
  callp printf,"Fragmentation=%d%%   \n",eax
  popad
  ret
showram endp

HeapWalk proc
  callp printf,"_heapwalk() output to HeapWalk.DAT..."
  mov hi._pentry,NULL
  callp fopen,"HeapWalk.DAT","+wb"
  .if eax==NULL
    mov edx,"fopen() failed"
    jmp failed
  .endif
  mov f,eax
@@:
  callp _heapwalk,offset hi
  .if eax==_HEAPOK
    callp fprintf,f,"Heap Node : Offset=%#010x Size=%#010x",hi._pentry,hi._size
    .if hi._useflag
      callp fprintf,f," Free=YES\r\n"
    .else
      callp fprintf,f," Free=NO \r\n"
    .endif
    jmp @b
  .elseif eax==_HEAPEND
    callp fprintf,f,"EOL\r\n"
    callp fclose,f
    ret
  .endif
  mov edx,"_heapwalk()"
  jmp failed
HeapWalk endp

