#include <system.h>

byte yes[80];
double r_max=999999999999999999999.0;
float r4_1=4.4444444444;
float r4_2=0.5;
double r8_1=0.0;
double r8_2=10.0;
long double r10_1=10.045;   //WARNING : is only a "double" in WC

float g_1=0.00001;      //will use %f
float g_2=0.000001;     //will use %f
float g_3=0.0000001;    //will use %e

void main(void) {
  clrscr();

  if (!_fpu) {
    printf("FPU not detected!\n");
    exit(0);
  }

  printf("%b\n",(int)r4_1);

  printf("\n\tPrintf tests:\n\n");
  
  sprintf(yes,"Decimal tests:\n");
  print(yes);
  printf("(d)=%i\n",1234);
  sprintf(yes,"(d)=%u\n",01234);
  print(yes);
  printf("(d)=%d\n",-1234);

  printf("\nFloat tests:\n");
  printf("%%f=%26.20f\n",r4_1);
  printf("%%f=%f\n",r_max);  //tests max float range
  printf("%%e=%10.2e\n",r4_2);
  printf("%%f=%10.2lf\n",r8_1);
  printf("%%f=%lf\n",r8_2);
  printf("%%f=%*.*Lf\n",10,2,r10_1);

  asm fldl2e  //st = log2(e)
  asm fstp r4_1
  asm fwait

  printf("%%f=%f\n",r4_1);  //1.44...
  printf("%%g(f)=%lg\n",g_1);
  printf("%%g(f)=%lg\n",g_2);
  printf("%%g(e)=%lg\n",g_3);
  r4_1=atof("10.4");
  printf("%%f=%f\n\n",r4_1);

  printf("Press a key...\n");
  getch();

  printf("\nHex tests:\n");
  printf("(x)=%x\n",0x56cd);
  printf("(x)=%#x\n",0x12ab56cd);
  printf("(X)=%#X\n",0x12ab56cd);
  printf("\nBinary tests:\n");
  printf("(b)=%05b\n",1);
  printf("(b)=%b\n",0x5678);
  printf("(b)=%b\n",155);

  printf("\nOctal tests:\n");
  printf("(o)=%o\n",0x5678);
  printf("(o)=%*o\n",5,155);

  printf("\nPrintf %s %s","totally","rulez\n");
  sprintf(yes,"It %s %s %i%s%i%s%i\n","Truely","does\n",1,"+",1,"=",2);
  print(yes);
}
