#ifndef __VIDEO_H__
#define __VIDEO_H__

#include <stddef.h>

#include <vesa.h>

struct mouse_user {
  word x;
  word y;
  word but;
};

//Mouse Pointer header  (QLIB v2.06)
struct g_mousehead {
  byte head[4];   //='PTR',26
  word x;       //ptr size
  word y;
  word hx;      //hot spot
  word hy;
  byte bpp;   //bits / pixel  (ignored)
  byte bypp;  //bytes / pixel
  byte flg;   //(bit 0=Obsolete)
              //(bit 1=bitpacked-mono color - g_setmousecolor())
};

//Font Header  (QLIB v1.1)
struct g_fnthead {
  byte head[4];   //='FNT',26
  word x;
  word y;
  byte bpp;   //bits / pixel  (ignored)
  byte bypp;  //bytes / pixel
  byte flg;   //(bit 0=Obsolete)
              //(bit 1=bitpacked-mono-color - g_setfntcolor())
};

#define G_FNT_OBSOLETE 0x01
#define G_FNT_MONO     0x02

#define G_TEXT 1
#define G_VGA 2
#define G_VESA 3
#define G_MODEX 4

#ifdef __cplusplus
  extern "C" {
#endif

//video sub-system
extern sdword g_getmode (word,word,byte);
extern void g_setmode (void);
extern void *g_alloc (void);

//text functions
extern sdword t_setmode (byte,byte);
extern void *t_savestate (void);
extern void t_restorestate (void *);
extern void t_box1 (dword x1,dword y1,dword x2,dword y2,byte clr); //FIX : v2.11 Beta #5 : missing clr
extern void t_box2 (dword x1,dword y1,dword x2,dword y2,byte clr); //FIX : v2.11 Beta #5 : missing clr
extern void t_boxfill (dword x1,dword y1,dword x2,dword y2,word _char);  //NOTE : _char is a 16bits!
extern void t_backboxfill (dword x1,dword y1,dword x2,dword y2,byte clr);
extern void t_printxy(dword x,dword y,char *s);   //FIX : v2.11 Beta #5 : was missing *
extern void t_printf(dword x,dword y,char *s,...);  //FIX : v2.11 Beta #5 : was missing *

extern void g_copy (void);      //copies buffer to VRAM
extern void g_copyblk (dword x1,dword y1,dword x2,dword y2);
extern void g_copybuf (void *buf,dword x1,dword y1,dword x2,dword y2);
extern void g_setbuf (void *);
extern void *g_getbuf (void);
extern void g_setpal (void *);  //768 bytes expected
extern void g_setcol (byte n,byte r,byte g,byte b);
extern void g_getpal (void *);  //768 bytes expected
extern void g_getcol (byte n,byte *r,byte *g,byte *b);
extern void g_get (void *a,dword x1,dword y1,dword x2,dword y2);
extern void g_put (void *a,dword x1,dword y1,dword x2,dword y2);
extern void g_put0 (void *a,dword x1,dword y1,dword x2,dword y2);
extern void g_putb0 (void *a,dword x1,dword y1,dword x2,dword y2,dword clr);
extern void g_waitvsync (void);      
extern void g_line (dword x1, dword y1, dword x2, dword y2, dword clr);
extern void g_putpixel (dword x, dword y, dword clr);
extern dword g_getpixel (dword x, dword y);

//direct video in/output
extern void gd_get (void *a,dword x1,dword y1,dword x2,dword y2);
extern void gd_put (void *a,dword x1,dword y1,dword x2,dword y2);
extern void gd_put0 (void *a,dword x1,dword y1,dword x2,dword y2);
extern void gd_putb0 (void *a,dword x1,dword y1,dword x2,dword y2,dword clr);

extern sbyte mouse_init (void);
extern void mouse_uninit (void);
extern void mouse_setcursor (void *a);
extern void *mouse_loadcursor (char *);
extern void mouse_setcolor (dword);
extern dword mouse_getcolor (void);
extern void mouse_setspd (byte x,byte y);
extern void mouse_setwin (dword x1,dword y1,dword x2,dword y2);
extern void mouse_on (void);
extern void mouse_off (void);

extern void mouse_setuser (void *,struct mouse_user*);
extern void mouse_setpos (dword x,dword y);

extern void *g_loadfnt (char *n);   //FIX v2.03 Beta #2
extern void g_setfnt (void *);       //FIX v2.03 Beta #2
extern void g_setfntcolor (dword);
extern void g_putch (dword x,dword y,char ch);
extern void g_printxy (dword x,dword y,char *s);
extern void g_printf (dword x,dword y,char * s,...);

extern void g_hline (dword x1,dword y,dword x2,dword col);
extern void g_vline (dword x,dword y1,dword y2,dword col);  //FIX : v2.11 Beta #5 : args were incorrectly named
extern void g_box   (dword x1,dword y1,dword x2,dword y2,dword col);
extern void g_boxfill (dword x1,dword y1,dword x2,dword y2,dword col);
extern void g_cls (void);

extern dword _v_buffer;   //buffer you have alloc (set by gsetbuf())
extern dword _v_linear;   //linear addr to VRAM (may not be 0a0000h under VESA 2.0)
extern byte _v_debug;     //print debug info during g_getmode(), g_setmode()

//vesa
extern sword vesa_init(void);   //FIX : v2.11 Beta #6 : was sbyte!
extern void vesa_func06(void);
extern void vesa_setstart(dword,dword);
extern sbyte vesa_firstmode(void);
extern sbyte vesa_nextmode(void);

extern struct vesa_infoblock vesa_info;
extern struct vesa_modeinfoblock vesa_modeinfo;

#ifdef __cplusplus
  }
#endif

#endif
