#ifndef __DLL_H__
#define __DLL_H__

#define DLL_VERSION 0x103

#ifdef __cplusplus
  extern "C" {
#endif

extern sdword dll_export     (dword hnd,void *name,void *addr);
extern sdword dll_export_list(dword hnd,void *list,dword num);

extern sdword dll_import_idx (dword hnd,dword idx);
extern sdword dll_import_nam (dword hnd,void *name);
extern sdword dll_import_hint(dword hnd,void *name,dword hint);
extern sdword dll_numexports (dword hnd);
extern sbyte  dll_call       (dword hnd,void *name,...);

extern sdword dll_load       (char *fn);
extern sbyte  dll_unload     (dword hnd);

#ifdef __cplusplus
  }
#endif

#ifdef __cplusplus
/* overloading is definitely nice.. */
inline sdword dll_import(dword hnd,dword idx)  {
  return dll_import_idx(hnd,idx);
};

inline sdword dll_import(dword hnd,void *name) {
  return dll_import_nam(hnd,name);
};

inline sdword dll_import(dword hnd,void *name,dword hint) {
  return dll_import_hint(hnd,name,hint);
};
#endif

#ifdef _DLL_CODE_
extern FILE **__stdin;
extern FILE **__stdout;
extern FILE **__stderr;
extern FILE **__stdaux;
extern FILE **__stdprn;

extern word *__selcode;
extern word *__seldata;

extern word *__errno;

extern byte *___lfn;

extern char ***___argv;
extern byte *___argc;

extern word *___ds_;
extern word *___es_;

extern word *___8kbufferseg;
extern dword *___8kbuffer;

extern word *___pic_master;
extern word *___pic_slave;

#define stdin (*__stdin)
#define stdout (*__stdout)
#define stderr (*__stderr)
#define stdaux (*__stdaux)
#define stdprn (*__stdprn)

#define selcode (*__selcode)
#define seldata (*__seldata)

#define errno (*__errno)

#define _lfn (*___lfn)

#define _argv (*___argv)
#define _argc (*___argc)

#define _ds_ (*___ds_)
#define _es_ (*___es_)

#define _8kbufferseg (*___8kbufferseg)
#define _8kbuffer (*___8kbuffer)

#define _pic_master (*___pic_master)
#define _pic_slave (*___pic_slave)
#endif ; _DLL_CODE_

#endif
