              Title _delay.Asm
              Page ,120
;****************************************************************
;* File Id.                       Delay.Asm                     *
;* Author.                        Stan Milam.                   *
;* Date Written.                  06/12/89.                     *
;*                                                              *
;*             (c) Copyright 1989, 1990 by Stan Milam           *
;*                                                              *
;* NOTE: This file is assembled with Micorsoft MASM 5.10, but   *
;* Borland's Turbo Assembler can be used too.                   *
;****************************************************************
;
Gate          Equ       61h
Timer2        Equ       42h
Cntl          Equ       43h
Mode3         Equ       0b6h
Factor        Equ       1193
Range         Equ       7

              Dosseg                        ;Use standard segmentation
              .Model Huge

              .Code
              Page
;************************************************************
;*                          _Delay                          *
;*                                                          *
;* This procedure will program channel two of the 8253 timer*
;* chip to create a very accurate delay routine.  Can not   *
;* use this routine in conjuction with sound routines as    *
;* they use channel two to create square wave frequencies   * 
;* sound.                                                   *
;                                                           *
;* void __delay(unsigned milliseconds);                     *
;************************************************************
              Public    _delay
_delay        Proc      Far
              Push      Bp              ;Set up the stack frame
              Mov       Bp,Sp
              Push      Ax              ;Save the registers
              Push      Bx
              Push      Cx
              Push      Dx
              Xor       Cx,Cx           ;Clear the counter
              Mov       Bx,[Bp+6]       ;Get the number of milliseconds
              Mov       Dx,Gate         ;Gate port
              In        Al,Dx           ;Get in Gate value
              Or        Al,01h          ;Open Gate to system timer chnl 2
              Out       Dx,Al           ;Put it 
              Mov       Dx,Cntl         ;Timer Control register
              Mov       Al,Mode3        ;Mode 3,r/w,lsb,msb,binary
              Out       Dx,Al           ;
              Mov       Dx,Timer2       ;Timer 2 port
              Mov       Ax,Factor       ;System timer 1.19mhz-1/1000
              Out       Dx,Al           ;Send low byte
              Mov       Al,Ah           ;Get msb ready
              Out       Dx,Al           ;Send high byte
MT_Loop:
              In        Al,Dx           ;Read lsb count from latch
              Mov       Ah,Al           ;Put it in Ah
              In        Al,Dx           ;Read msb count from latch
              Xchg      Ah,Al           ;Reverse them for full word value
              Cmp       Ax,Range        ;Is the count < Range
              Jg        MT_Loop         ;No - keep looking
              Inc       Cx              ;Count < range increment our count
              Cmp       Bx,Cx           ;Our count reached max yet?
              Jnz       MT_Loop         ;No - keep on keeping on
              Mov       Dx,Gate         ;Reset the open Gate
              In        Al,Dx           ;Read in Gate Value
              And       Al,0fch         ;Mask off two lowest bits
              Out       Dx,Al           ;Close the Gate
              Pop       Dx              ;Restore the registers
              Pop       Cx
              Pop       Bx
              Pop       Ax
              Pop       Bp
              Ret
_delay        Endp
              End

