/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */
#include "myid2.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid3.h"       /* gaussjordan(), inverse() with the identity matrix */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblock[3][3*TWOCOL]=
{
  14,1,  -16,1,  -19,1,
  13,1,  -13,1,   12,1,
 -12,1,   17,1,  -13,2,
};
matrix m={3,3*TWOCOL,&pblock[0][0]};


double pblockAT [3][3*TWOCOL];  matrix mAT  = {3,3*TWOCOL,&pblockAT [0][0]};
double pblockT  [3][3*TWOCOL];  matrix mT   = {3,3*TWOCOL,&pblockT  [0][0]};

double pblockID [3][3*TWOCOL];  matrix mID  = {3,3*TWOCOL,&pblockID [0][0]};
double pblockIDT[3][3*TWOCOL];  matrix mIDT = {3,3*TWOCOL,&pblockIDT[0][0]};
double pblockID0[3][3*TWOCOL];  matrix mID0 = {3,3*TWOCOL,&pblockID0[0][0]};
double pblockID1[3][3*TWOCOL];  matrix mID1 = {3,3*TWOCOL,&pblockID1[0][0]};
double pblockID2[3][3*TWOCOL];  matrix mID2 = {3,3*TWOCOL,&pblockID2[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 printf(" The matrix mA \n");
 printmF(&m);
 copymF(&m,&mAT);

idF3(&mID,&mT,&m,0);copymF(&mID,&mID0);printf("mID0");printmF(&mID0);getchar();
idF3(&mID,&mT,&m,1);copymF(&mID,&mID1);printf("mID1");printmF(&mID1);getchar();
idF3(&mID,&mT,&m,2);copymF(&mID,&mID2);printf("mID2");printmF(&mID2);getchar();

 printf("\n mID2 * mID1 : \n");
 multmF(&mID2, &mID1, &mID);
 printmF(&mID );
 getchar();

 printf("\n (mID2 * mID1) * mID0 : \n");
 multmF(&mID,  &mID0, &mIDT);
 printmF(&mIDT );
 getchar();

 copymF(&mAT,&m);
 printf("\n mID * mA : \n");
 multmF(&mIDT,&m,&mT);
 printmF(        &mT);

 printf("\n Press a key to continue");
 getchar();
}



