/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
ab_C(int n,int p)
{
int      i;
int      j;
fraction a;
fraction b;
fraction ab;

double pC   [n][p*TWOCOL];matrix mC   ={n,p*TWOCOL,&pC   [0][0]};
double pbC  [n][p*TWOCOL];matrix mbC  ={n,p*TWOCOL,&pbC  [0][0]};
double pa_bC[n][p*TWOCOL];matrix ma_bC={n,p*TWOCOL,&pa_bC[0][0]};
double pab_C[n][p*TWOCOL];matrix mab_C={n,p*TWOCOL,&pab_C[0][0]};

double pa_bC_mns_ab_C[n][p*TWOCOL];
matrix ma_bC_mns_ab_C={n,p*TWOCOL,&pa_bC_mns_ab_C[0][0]};


/*-------------------------------- PROGRAM ---------------------------------- */
  a.numer = (int)     (randF(9)+1);
  a.denom = 1;
  b.numer = (randF(9)+1);
  b.denom = 1;

  randmI(&mC,10);

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f\n\n",a.numer);
  printf("                                                      ");
  printf("b = %.0f\n\n",b.numer);
  printf("                                                      C  :");
  printmI4(&mC);
  getchar();


  clrscrn();
  printf("                                                      ");
  printf("b = %.0f\n\n",b.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                      bC :\n");
  smultmF(b,&mC,&mbC);
  printmI4(     &mbC);
  getchar();


  clrscrn();
  printf("                                                      ");
  printf("a = %.0f\n\n", a.numer);
  printf("                                                     bC  :");
  printmI4( &mbC);
  printf("                                                   a(bC) :\n");
  smultmF(a,&mbC,&ma_bC);
  printmI4(      &ma_bC);
  getchar();


  clrscrn();
  ab = multF(a,b);
  printf("                                      ");
  printf(" ab = %.0f * (%.0f) = %.0f\n\n", a.numer, b.numer,ab.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                   (ab)C :\n");
  smultmF(ab,&mC,&mab_C);
  printmI4(      &mab_C);
  getchar();

  clrscrn();
  printf("                                                 a(bC)   :");
  printmI4(&ma_bC);
  printf("                                                 (ab)C   :");
  printmI4(&mab_C);
  printf("\n");
  printf("                                       (a(bC)) - ((ab)C) :");
  submF(&ma_bC,&mab_C,&ma_bC_mns_ab_C);
  printmI4(           &ma_bC_mns_ab_C);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            a(bC) = (ab)C                         ");
  printf("\n            *************                       \n");
  printf("\n The size of  mC         : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"pli.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"pli.exe 2 3\" -> 2x3                  ");
  printf("\n          \"pli.exe 1 5\" -> 1x5                  ");
  printf("\n          \"pli.exe 4 2\" -> 4x2                  ");
  printf("\n          \"pli.exe 5 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;

  srand(time(&t));
  hello();

do
{
if( argc == 3 && atoi(argv[1])&& atoi(argv[2]) )
 {
  n = atoi(argv[1]);
  p = atoi(argv[2]);

  if( n < 1){n=1;}
  if( n > 5){n=5;}
  if( p < 1){p=1;}
  if( p > 5){p=5;}
 }
else
 {
  n = (int) fabs(randF(5)+1);
  p = (int) fabs(randF(5)+1);
 }

  ab_C(n,p);

  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}












