/* yd_dot.h                     freeware                   xhunga@tiscali.fr  */


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction innerprod_uDotv_uv(
pmatrix mu,
pmatrix mv
)
{
fraction InnerProduct;

double pbuv [MXR][MXC*TWOCOL];matrix muv ={MXR,MXC*TWOCOL,&pbuv [0][0]};

                 muv.rows =1;    muv.cols =1*TWOCOL;

  if (mu->rows != 1 ||
      mu->cols != mv->rows * TWOCOL ||
      mv->cols != TWOCOL
     )
    {
     printf(" uDotv_uv() error.\n\n");

     printf(" u.rows = 1\n");
     printf(" u.cols = v.rows\n");
     printf(" v.cols = 1\n");

     printf("\nPress Return to continue\n");
     getchar();
     exit(1);
    }

  multmF(mu,mv,&muv);

  InnerProduct.numer = *(muv.pblock + 0 *muv.cols + 0  );
  InnerProduct.denom = *(muv.pblock + 0 *muv.cols + 1  );

  return(InnerProduct);
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction innerprod_uDotv_uvT(
pmatrix mu,
pmatrix mv
)
{
fraction InnerProduct             ;
int      n           =  mu->cols / TWOCOL;

double pbvT   [MXR][MXC*TWOCOL];matrix mvT   ={MXR,MXC*TWOCOL,&pbvT   [0][0]};
double pbuvT  [MXR][MXC*TWOCOL];matrix muvT  ={MXR,MXC*TWOCOL,&pbuvT  [0][0]};

                 mvT.rows =n;       mvT.cols =  TWOCOL;
                muvT.rows =1;      muvT.cols =  TWOCOL;

  if (mu->rows != mv->rows ||
      mu->cols != mv->cols ||
      mu->rows != 1
     )
    {
     printf(" uDotv_uvT() error.\n\n");

     printf(" u.rows = v.rows\n");
     printf(" u.cols = v.cols\n");
     printf(" u.rows = 1\n");

     printf("\nPress Return to continue\n");
     getchar();
     exit(1);
    }

  transposemF(mv,&mvT);

  multmF(mu,&mvT,&muvT);

  InnerProduct.numer = *(muvT.pblock + 0 *muvT.cols + 0  );
  InnerProduct.denom = *(muvT.pblock + 0 *muvT.cols + 1  );

  return(InnerProduct);
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction innerprod_uDotv_vTu(
pmatrix mu,
pmatrix mv
)
{
fraction InnerProduct             ;
int      n           =  mu->rows;

double pbvT   [MXR][MXC*TWOCOL];matrix mvT   ={MXR,MXC*TWOCOL,&pbvT   [0][0]};
double pbvT_u [MXR][MXC*TWOCOL];matrix mvT_u ={MXR,MXC*TWOCOL,&pbvT_u [0][0]};

                  mvT.rows =1;      mvT.cols =n*TWOCOL;
                mvT_u.rows =1;    mvT_u.cols =1*TWOCOL;

  if (mu->rows != mv->rows ||
      mu->cols != mv->cols ||
      mu->cols != TWOCOL
     )
    {
     printf(" uDotv_vTu() error.\n\n");

     printf(" u.rows = v.rows\n");
     printf(" u.cols = v.cols\n");
     printf(" u.cols = 1\n");

     printf("\nPress Return to continue\n");
     getchar();
     exit(1);
    }

  transposemF(mv,&mvT);

  multmF(&mvT,mu,&mvT_u);

  InnerProduct.numer = *(mvT_u.pblock + 0 *mvT_u.cols + 0  );
  InnerProduct.denom = *(mvT_u.pblock + 0 *mvT_u.cols + 1  );

  return(InnerProduct);
}


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
fraction innerprod_uDotv_vu(
pmatrix mu,
pmatrix mv
)
{
fraction InnerProduct             ;
int      n           =  mu->rows;

double pbvu [MXR][MXC*TWOCOL];matrix mvu ={MXR,MXC*TWOCOL,&pbvu [0][0]};

                mvu.rows =1;    mvu.cols =1*TWOCOL;

  if (mu->rows * TWOCOL != mv->cols ||
      mu->cols          != TWOCOL   ||
      mv->rows          != 1
     )
    {
     printf(" uDotv_vu() error.\n\n");

     printf(" u.rows = v.cols\n");
     printf(" u.cols = 1\n");
     printf(" v.rows = 1\n");

     printf("\nPress Return to continue\n");
     getchar();
     exit(1);
    }

  multmF(mv,mu,&mvu);

  InnerProduct.numer = *(mvu.pblock + 0 *mvu.cols + 0  );
  InnerProduct.denom = *(mvu.pblock + 0 *mvu.cols + 1  );

  return(InnerProduct);
}

