/* xpgnplt.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltvectcol3d(
   char filename[11],
pmatrix mA
)
{
FILE *fp;
  int j;

   fp = fopen(filename,"w");

   for (j = 0; j < mA->cols;j++,j++)
    {
     fprintf(fp,"  %.3lf  %.3lf  %.3lf \n",
                 *(mA->pblock + 0 *mA->cols + j     )/
                 *(mA->pblock + 0 *mA->cols + j + 1 ),
                 *(mA->pblock + 1 *mA->cols + j     )/
                 *(mA->pblock + 1 *mA->cols + j + 1 ),
                 *(mA->pblock + 2 *mA->cols + j     )/
                 *(mA->pblock + 2 *mA->cols + j + 1 ));
    }

  fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltaxyz3d(
   char filename[11]
)
{
FILE *fp;

   fp = fopen(filename,"w");

   fprintf(fp,"\n");
   fprintf(fp,"    9.000   0.000   0.000\n");
   fprintf(fp,"   -9.000   0.000   0.000\n");
   fprintf(fp,"    0.000   0.000   0.000\n");
   fprintf(fp,"    0.000   9.000   0.000\n");
   fprintf(fp,"    0.000  -9.000   0.000\n");
   fprintf(fp,"    0.000   0.000   0.000\n");
   fprintf(fp,"    0.000   0.000   9.000\n");
   fprintf(fp,"    0.000   0.000  -9.000 \n");
   fprintf(fp,"\n");

   fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltxypln3d(
   char filename[11]
)
{
FILE *fp;

   fp = fopen(filename,"w");

   fprintf(fp,"\n");
   fprintf(fp,"        9.000   9.000   0.000\n");
   fprintf(fp,"        9.000  -9.000   0.000\n");
   fprintf(fp,"       -9.000  -9.000   0.000\n");
   fprintf(fp,"       -9.000   9.000   0.000\n");
   fprintf(fp,"        9.000   9.000   0.000\n");
   fprintf(fp,"\n");

   fclose(fp);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltxzpln3d(
   char filename[11]
)
{
FILE *fp;

   fp = fopen(filename,"w");

   fprintf(fp,"\n");
   fprintf(fp,"        9.000   0.000   9.000\n");
   fprintf(fp,"        9.000   0.000  -9.000\n");
   fprintf(fp,"       -9.000   0.000  -9.000\n");
   fprintf(fp,"       -9.000   0.000   9.000\n");
   fprintf(fp,"        9.000   0.000   9.000\n");
   fprintf(fp,"\n");

   fclose(fp);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gnpltyzpln3d(
   char filename[11]
)
{
FILE *fp;

   fp = fopen(filename,"w");

   fprintf(fp,"\n");
   fprintf(fp,"        0.000   9.000   9.000\n");
   fprintf(fp,"        0.000   9.000  -9.000\n");
   fprintf(fp,"        0.000  -9.000  -9.000\n");
   fprintf(fp,"        0.000  -9.000   9.000\n");
   fprintf(fp,"        0.000   9.000   9.000\n");
   fprintf(fp,"\n");

   fclose(fp);
}
