/**  strftime.c **********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     Localized strftime().
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <time.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "_locale.h"

size_t strftime(char *str, size_t maxs, const char *fmt, const struct tm *t)
{
 size_t len;

 if (!maxs--) goto Error;

 for(len = 0; maxs && *fmt; ++fmt)
   if (*fmt != '%')
     {
      maxs--;
      str[len++] = *fmt;
     }
   else
     {
      int ii;
      char buf[7 * sizeof(int) / 2]; /* is sufficient for any %d */
      const char *fs = buf;
      size_t s_name = 100;
#if     STRFTIME_WIN
      int O_modifier = 0;
#endif

Fmt:  switch(*++fmt)  /* Needed to be localized: %c %p %r %x %X */
        {             /* STRFTIME_EXT - not described in POSIX  */
      case  0 : goto FmtEnd;
      case 'a':
#if    USE_ABBR_NAMES
         if (_lc_Txt_)
                 { fs = _lc_WdayS[t->tm_wday]; break; }
#endif
         s_name = 3;
      case 'A':
         fs = _lc_Wday_[_lc_Txt_][t->tm_wday]; break;
      case 'h': /* STRFTIME_EXT */
      case 'b':
#if    USE_ABBR_NAMES
         if (_lc_Txt_)
                 { fs = _lc_MonthS[t->tm_mon]; break; }
#endif
         s_name = 3;
      case 'B':
         fs = _lc_Month_[_lc_Txt_][t->tm_mon]; break;
      case 'c':
         fs = _lc_fmt_c_[_lc_Fmt_];
strft:   ii = strftime(str + len, maxs + 1, fs, t);
         fs = NULL;                       break;
#if     STRFTIME_EXT
      case 'C': /* STRFTIME_EXT */
         ii = t->tm_year / 100 + 19; goto sprn2;
#endif
      case 'd':
         ii = t->tm_mday;
sprn2:
#if     STRFTIME_WIN
         if (O_modifier)             goto  sprn;
#endif
         sprintf(buf, "%02u", ii);        break;
#if     STRFTIME_EXT
      case 'D': /* STRFTIME_EXT */
         fs = _lc_fmt_xD[0];         goto strft;
      case 'e': /* STRFTIME_EXT */
         sprintf(buf, "%2u", t->tm_mday); break;
/*    case 'E':    STRFTIME_EXT "Era specefic" see %'O' */
/*    case 'h':    STRFTIME_EXT see %'b' */
#endif
      case 'H':
         ii = t->tm_hour;            goto sprn2;
      case 'I':
         if (!(ii = t->tm_hour % 12)) ii = 12;
                                     goto sprn2;
      case 'j':
         sprintf(buf, "%03u", t->tm_yday + 1);
                                          break;
      case 'm':
         ii = t->tm_mon + 1;         goto sprn2;
      case 'M':
         ii = t->tm_min;             goto sprn2;
#if     STRFTIME_EXT
      case 'n': /* STRFTIME_EXT */
         str[len++] = '\n'; maxs--;    continue;
      case 'N': /* STRFTIME_EXT */
         fs = _lc_fmt_N_;            goto strft;
      case 'O': /* STRFTIME_EXT "Alternate digits" */
#if     STRFTIME_WIN
                O_modifier++;
#endif
      case 'E': /* STRFTIME_EXT "Era specefic" */
                                     goto   Fmt;
#elif   STRFTIME_WIN
      case 'O': O_modifier++;        goto   Fmt;
#endif
      case 'p':
         fs = _lc_AmPm_[_lc_Txt_][t->tm_hour >= 12];
                                          break;
#if     STRFTIME_EXT
      case 'r': /* STRFTIME_EXT */
         fs = _lc_fmt_rI;            goto strft;
      case 'R': /* STRFTIME_EXT */
         fs = _lc_fmt_RH;            goto strft;
#endif
      case 'S':
         ii = t->tm_sec;             goto sprn2;
#if     STRFTIME_EXT
      case 'T': /* STRFTIME_EXT */
         fs = _lc_fmt_XT[0];         goto strft;
      case 't': /* STRFTIME_EXT */
         str[len++] = '\t'; maxs--;    continue;
      case 'u': /* STRFTIME_EXT */
         if (!(ii = t->tm_wday)) ii = 7;
                                     goto  sprn;
#endif
      case 'U':
         ii = t->tm_wday;           /* 0 = Sunday */
yweek:   ii = (t->tm_yday - ii + 7) / 7;
                                     goto sprn2;
#if     STRFTIME_EXT && 0
      case 'V': /* STRFTIME_EXT */
         ii = -3 + t->tm_wday;        /* - if Sun - first */
           /* -3 + (t->tm_wday + 6) % 7; - if Mon - first */
         if (ii <= t->tm_yday)       goto yweek;
         ii = 53;                    goto sprn2;
#endif
      case 'w':
         ii = t->tm_wday;
sprn:    sprintf(buf, "%u", ii);          break;
      case 'W':
         ii = (t->tm_wday + 6) % 7; /* 0 = Monday */
                                     goto yweek;
      case 'x':
         fs = _lc_fmt_xD[_lc_Fmt_];  goto strft;
      case 'X':
         fs = _lc_fmt_XT[_lc_Fmt_];  goto strft;
      case 'y':
         ii = t->tm_year % 100;      goto sprn2;
      case 'Y':
         ii = 1900 + t->tm_year;     goto sprn2;
      case 'Z':
         fs = tzname[t->tm_isdst > 0];
         if (t->tm_isdst < 0) fs = "???";
         break;
/*    case '%': */
      default:
         buf[0] = *fmt; buf[1] = '\0';    break;
        } /* end of switch() */

      if (fs != NULL)
        {
         ii = strlen(fs);
         if (ii > s_name) ii = s_name;
         if (ii > maxs) break;
         memcpy(str + len, fs, ii);
        }
      else if (!ii) break;
      len += ii; maxs -= ii;
     } /* end of else, for */

FmtEnd:
 str[len] = '\0';
 if (!*fmt) return len;
Error:
 errno = E2BIG;
 return 0;
}

/* end of strftime.c */