/* Copyright 1994-95 by Kai Hofmann */

#ifdef _AMIGA
   #define _ISO8859_Latin1
#endif
#ifndef BOOLEAN
  typedef short bool;
  #define true	1
  #define false	0
  #define BOOLEAN
#endif
#ifndef DATELIB
  typedef enum
    #if defined(__cplusplus) && defined(__SASC_650)
      WeekdaysENUM
    #endif
               {dayerr,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday,Sunday} Weekdays;
  typedef enum
    #if defined(__cplusplus) && defined(__SASC_650)
      MoonPhasesENUM
    #endif
               {NewMoon,FirstQuarter,FullMoon,LastQuarter} MoonPhases;
  typedef enum
    #if defined(__cplusplus) && defined(__SASC_650)
      DateTextsENUM
    #endif
               {DAY,MONTH,YEAR,WEEK,WEEKDAY,HOUR,MINUTE,SECOND,YESTERDAY,TODAY,TOMORROW} DateTexts;
  #define DATELIB
#endif
#ifndef LOCALE
  typedef enum
    #if defined(__cplusplus) && defined(__SASC_650)
      LanguagesENUM
    #endif
              {Locale,English,Deutsch,
                #ifdef _ISO8859_Latin1
                  franais,espaol,portugus,
                #else
                  francais,espanol,portugues,
                #endif
                dansk,italiano,nederlands,norsk,svenska,polski,suomalainen
               } Languages;
  typedef enum
    #if defined(__cplusplus) && defined(__SASC_650)
      CountriesENUM
    #endif
               {unknown,Italia,Deutschland,Schweiz,Danmark,Nederland,GreatBritain} Countries;
  #define LOCALE
#endif

/* Module initialization */
#ifndef __SASC_650
  void _DateInit(void);
  void _DateCleanup(void);
  #undef __MakeLib
#endif

#ifndef __MakeLib
  bool JulianLeapYear(const int year);
  bool GregorianLeapYear(const int year);
  bool HeisLeapYear(const int year);
  unsigned short JulianMonthDays(const unsigned short month, const int year);
  unsigned short GregorianMonthDays(const unsigned short month, const int year);
  unsigned short HeisMonthDays(const unsigned short month, const int year);
  unsigned int JulianYearDays(const int year);
  unsigned int GregorianYearDays(const int year);
  unsigned int HeisYearDays(const int year);
  short Compare2Dates(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
  long JulianDayDiff(const unsigned short day1, unsigned short month1, int year1, const unsigned short day2, unsigned short month2, int year2);
  long GregorianDayDiff(const unsigned short day1, unsigned short month1, int year1, const unsigned short day2, unsigned short month2, int year2);
  long HeisDayDiff(const unsigned short day1, unsigned short month1, int year1, const unsigned short day2, unsigned short month2, int year2);
  Weekdays JulianWeekday(const unsigned short day, unsigned short month, int year);
  Weekdays GregorianWeekday(const unsigned short day, unsigned short month, int year);
  Weekdays HeisWeekday(const unsigned short day, unsigned short month, int year);
  unsigned short JulianDaysBeforeWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday);
  unsigned short GregorianDaysBeforeWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday);
  unsigned short HeisDaysBeforeWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday);
  unsigned short JulianDaysAfterWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday);
  unsigned short GregorianDaysAfterWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday);
  unsigned short HeisDaysAfterWeekday(const unsigned short day, const unsigned short month, const int year, const Weekdays weekday);
  unsigned int JYearToScaliger(const int year);
  unsigned int GYearToScaliger(const int year);
  unsigned int HYearToScaliger(const int year);
  int ScaligerYearToJ(const unsigned int syear);
  int ScaligerYearToG(const unsigned int syear);
  int ScaligerYearToH(const unsigned int syear);
  unsigned long JSYearToJD(const unsigned int syear);
  unsigned long GSYearToJD(const unsigned int syear);
  unsigned long HSYearToJD(const unsigned int syear);
  unsigned long JDtoMJD(const unsigned long jd);
  unsigned long MJDtoJD(const unsigned long mjd);
  unsigned long JulianToJD(const unsigned short day, const unsigned short month, const int year);
  unsigned long GregorianToJD(const unsigned short day, const unsigned short month, const int year);
  unsigned long HeisToJD(const unsigned short day, const unsigned short month, const int year);
  unsigned short GregorianMoonAge(const unsigned short day, const unsigned short month, const int year);
  unsigned short JulianWeek(const unsigned short day, const unsigned short month, const int year);
  unsigned short GregorianWeek(const unsigned short day, const unsigned short month, const int year);
  unsigned short HeisWeek(const unsigned short day, const unsigned short month, const int year);
  unsigned short WeekdayText(const Weekdays wday, char *const wtext, Languages lang);
  unsigned short MonthText(const unsigned short month, char *const mtext, Languages lang);
  unsigned short WeekdayShortText(const Weekdays wday, char *const wtext, Languages lang);
  unsigned short MonthShortText(const unsigned short month, char *const mtext, Languages lang);
  unsigned long GregorianMoonPhase(const unsigned short day, const unsigned short month, const int year, const MoonPhases phase);
  void DateText(const DateTexts text, char *const mtext, Languages lang, const bool plural);
  bool ValidJulianDate(const unsigned short day, const unsigned short month, const int year);
  bool ValidGregorianDate(const unsigned short day, const unsigned short month, const int year);
  bool ValidHeisDate(const unsigned short day, const unsigned short month, const int year);
  void SetCountry(const Countries country);
  #include "datetime.h"
  #ifndef __cplusplus
    void JulianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short *const dday, unsigned short *const dmonth, int *const dyear);
    void GregorianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short *const dday, unsigned short *const dmonth, int *const dyear);
    void HeisDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short *const dday, unsigned short *const dmonth, int *const dyear);
    void JDToJulian(const unsigned long jd, unsigned short *const day, unsigned short *const month, int *const year);
    void JDToGregorian(const unsigned long jd, unsigned short *const day, unsigned short *const month, int *const year);
    void JDToHeis(const unsigned long jd, unsigned short *const day, unsigned short *const month, int *const year);
    void JulianEaster(const int year, unsigned short *const dday, unsigned short *const dmonth);
    void GregorianEaster(const int year, unsigned short *const dday, unsigned short *const dmonth);
    void HeisEaster(const int year, unsigned short *const dday, unsigned short *const dmonth);
  #else
    void JulianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short &dday, unsigned short &dmonth, int &dyear);
    void GregorianDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short &dday, unsigned short &dmonth, int &dyear);
    void HeisDiffDate(const unsigned short day, const unsigned short month, const int year, int days, unsigned short &dday, unsigned short &dmonth, int &dyear);
    void JDToJulian(const unsigned long jd, unsigned short &day, unsigned short &month, int &year);
    void JDToGregorian(const unsigned long jd, unsigned short &day, unsigned short &month, int &year);
    void JDToHeis(const unsigned long jd, unsigned short &day, unsigned short &month, int &year);
    void JulianEaster(const int year, unsigned short &dday, unsigned short &dmonth);
    void GregorianEaster(const int year, unsigned short &dday, unsigned short &dmonth);
    void HeisEaster(const int year, unsigned short &dday, unsigned short &dmonth);
  #endif

  /* This are old routines that should not longe be used! They appear here only for compatibility to old releases! */
  bool JulianDaySmaller(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
  bool GregorianDaySmaller(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
  bool HeisDaySmaller(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
  bool JulianDayGreater(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
  bool GregorianDayGreater(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
  bool HeisDayGreater(const unsigned short day1, const unsigned short month1, const int year1, const unsigned short day2, const unsigned short month2, const int year2);
#else
#endif
