/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <stdlib.h>
#include <jlib.h>

#define COLOR 100

/* this demo shows how to stencil a buffer into another buffer */

int main(void)
{
 int xpos,ypos,buttons;
 image *jlb_pic;
 buffer_rec *offscreen,*off2;

 JLIB_DEBUG_OFF
 screen_set_video_mode();
 
 if(!MOUSE_AVAILABLE){
    jlib_exit("No Mouse Support.");
 }

 /* initialise screen sized buffer */
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 off2 = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);

 /* load jlb */
 jlb_pic = image_load_jlb("demo12.jlb");

 /* check that load was OK */
 if(jlb_pic == NULL){
    jlib_exit("JLB Load Failed.");
 }

 if(!mouse_present()){
    jlib_exit("No Mouse Installed.\n");
 }
 mouse_show_pointer();

 screen_block_set_pal(IMG_PALETTE(jlb_pic));

 /* copy the image to the offscreen buffers */
 buff_blit_img_to(offscreen,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));
 buff_blit_img_to(off2,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));

 /* hide the mouse pointer temporarily */
 mouse_hide_pointer();

 /* show buffer and turn on mouse pointer */
 screen_blit_fs_buffer(offscreen);
 mouse_show_pointer();

 /* loop moving the stenciled buffer with the mouse until a button is pressed */
 do{
    mouse_get_status(&xpos,&ypos,&buttons);
    buff_stencil_buff_to(off2,xpos-160,ypos-100,offscreen,0,0,320,200);
    mouse_hide_pointer();
    screen_blit_fs_buffer(off2);
    mouse_show_pointer();
    buff_clear(off2);
    buff_blit_img_to(off2,0,0,jlb_pic,0,0,IMG_MAX_X(jlb_pic),IMG_MAX_Y(jlb_pic));

 }while(!BUTTON_DOWN(buttons));

 /* set text mode and exit */
 screen_restore_video_mode();
 return(1);
}
