/****************************************************************
*	TRAPDOOR.C - A program to perform trap-door encryption.		*
*	To compile: cl trapdoor.c									*
*	Anthony D. Ennis, 4 Aug 1990								*
****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WHEELS 10			/* Maximum number of keys		*/
#define MAX_KEY_LEN 32			/* Maximum length of each key	*/

/****************************************************************
* the code "wheel" definitions									*
****************************************************************/
struct wheel_def
   	{
	char *pos;						/* Next char to XOR against	*/
	char value[MAX_KEY_LEN];		/* String of key characters	*/
	} wheel[MAX_WHEELS];			/* Array of keys			*/
int n_wheels;						/* Number of "wheels" to use*/

/****************************************************************
* tdInit - initialize the trapdoor "wheels"						*
* NOTE:	the array "wheel" is full								*
****************************************************************/
void tdInit(void)
	{
	int i;

	for (i=0; i < n_wheels; i++)
		wheel[i].pos = &wheel[i].value[0];
	}

/****************************************************************
* tdEncrypt - encrypt the current character						*
* INP:	c - the character to encrypt							*
* OUT:	the encrypted equivalent of the character				*
****************************************************************/
int tdEncrypt(int c)
	{
	int i;

	/* XOR the character against current char in each wheel	*/
	for (i=0; i<n_wheels; i++)
		{
		/* XOR character against the code wheel */
		c ^= *wheel[i].pos;

		/* Point to the next letter on code wheel */
		if ( *++wheel[i].pos == '\0')
			wheel[i].pos = wheel[i].value;
		}
	return c;
	}

/****************************************************************
* GetFile - prompt user for file name, open & return handle		*
*																*
* INP:	prompt - prompt string									*
*		mode - mode to use when opening file					*
* OUT:	NULL if error, otherwise an open file handle			*
****************************************************************/
FILE *GetFile(char *prompt, char *mode)
	{
	FILE *retval;
	char filename[100];

	fputs(prompt,stdout);
	scanf("%s",filename);
	retval = fopen(filename,mode);
	if (retval == NULL)
		{
		printf("Can't open file \"%s\"\n",filename);
		exit(1);
		}
	else
		return retval;
	}

/****************************************************************
* main - get the files and keys, encrypt the text and quit		*
****************************************************************/
int main(void)
	{
	int n_wheels;					/* Number of keys in use	*/
	int c;							/* The character to encrypt	*/
	int i;							/* Loop variable			*/

	FILE *inf, *outf;				/* Input & output file ptrs	*/

	/* Open the input and output files */
	inf  = GetFile("Input file name : ","rb");
	outf = GetFile("Output file name: ","wb");

	/* Get the number of keys. */
	printf("How many keys to use? ");
	scanf("%d",&n_wheels);
	if (n_wheels > MAX_WHEELS)
		{
		printf("The maximum number of keys is %d.\n",MAX_WHEELS);
		return 1;
		}

	/* Now get the keys. */
	for (i = 0; i < n_wheels; i++)
		{
		printf("Enter key %d : ",i+1);
		scanf("%32s",wheel[i].value);
		if (!*wheel[i].value)		/* A null key terminates	*/
			{						/* the list of keys			*/
			n_wheels = i+1;			/* Reset n_wheels			*/
			break;					/* And get out of the loop. */
			}
		}

	/* Set the wheels to the first position. */
	tdInit();

	/* Now cycle through plaintext encrypting each character	*/
	while( (c = getc(inf)) != EOF )
		{
		c = tdEncrypt(c);		/* Encrypt the character		*/
		putc( c, outf);			/* Write char to output file	*/
		}

	/* Neatness counts... */
	fclose(inf);
	fclose(outf);

	return 0;
	}
