INCLUDE CLIBC_16.INC

IFDEF CLIBC_16_FC_EXT_PTRS
 IF CLIBC_16_FC_EXT_PTRS EQ CLIBC_16_FC_EXT_PTRS_YES

_DATA SEGMENT
EXTERNDEF C p_fn_fc_iscsym:FN_CALL PTR
p_fn_fc_iscsym P_FN_CALL @iscsym
_DATA ENDS

 ENDIF
ENDIF

;iscsym() - Letter, underscore, digit
;int fn_call iscsym(const int);

;RETURNS:
;   0	if is NOT a c identifier character
;   1	if is	  a c identifier character

CLIBC_16_CS SEGMENT
iscsym PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, [num]

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A'     ; capital letter
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore
    je @@yes

    cmp bl, 'a'     ;lowercase letter
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
iscsym ENDP

; __fastcall
;   AX		num
;int __fastcall fn_call iscsym(const int);
@iscsym PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    jbe @@yes

    cmp bl, 'A'     ; capital letter
    jb @@done
    cmp bl, 'Z'
    jbe @@yes

    cmp bl, '_' ; underscore
    je @@yes

    cmp bl, 'a'     ;lowercase letter
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@iscsym ENDP
CLIBC_16_CS ENDS
END
