#include <stdio.h>
#include <graph.h>
#include "idpower.h"

/*
 * Simple program that displays what keys you are pressing down..
 *
 * You can link this with either using the idllPower library or using the
 * powerExe linking system. (using dllPower loader)
 */

int main()
  {
  setbuf(stdout, NULL);

  idllHookKbd();       // Hook the keyboard.

  _clearscreen(_GCLEARSCREEN);

  printf("Keys pressed: ");
  while(!idllKeyPressed(1)) /* Escape key */
     {
     if (idllKbdEvent()) // Check to see if any keyboard key has changed.
        {
        _clearscreen(_GCLEARSCREEN);
        printf("Keys pressed: ");
        for (int i=0;i<0x1FF;i++)   // Display all pressed key values.
           {
           if (idllKeyPressed(i)) printf("Key[0x%X], ", i);
           }
        }
     }

  idllUnhookKbd();  // Finally unhook keyboard, this is done automaticly when
                    // exiting to dos.
  return 0;
  }
