/*
 * 68K/386 32-bit C compiler.
 *
 * copyright (c) 1997, David Lindauer
 * 
 * This compiler is intended for educational use.  It may not be used
 * for profit without the express written consent of the author.
 *
 * It may be freely redistributed, as long as this notice remains intact
 * and either the original sources or derived sources 
 * are distributed along with any executables derived from the originals.
 *
 * The author is not responsible for any damages that may arise from use
 * of this software, either idirect or consequential.
 *
 * V1.85 July 2000
 * David Lindauer, camille@bluegrass.net
 *
 * Credits to Mathew Brandt for original K&R C compiler
 *
 */
#include        <stdio.h>
#include				<string.h>
#include				"lists.h"
#include        "expr.h"
#include        "c.h"
#include				"errors.h"

extern int ispascal, isstdcall;
extern FILE *listFile;
extern enum e_sym lastst;
extern long firstlabel,nextlabel;
extern char lastid[];
extern TABLE *gsyms,lsyms;
extern int global_flag;
extern int stdaddrsize, stdretblocksize;
extern int stackadd,stackmod;
extern TYP *head, *tail,**headptr;
extern char declid[100];
extern int prm_listfile;
extern int prm_cplusplus;
extern int stdintsize;
extern int goodcode;
extern int prm_linkreg;
extern TABLE lsyms;
extern int total_errors;
extern int cppflags;
extern SYM *declclass,*typequal;
int block_nesting,arg_nesting;
ENODE *block_rundown; /* maintains destructors for block, WILL maintain global
											 * scope when no funcs in progress but we don't use that
											 * now
                       */
ENODE **blk_run_link;

TABLE oldlsym;
LIST *varlisthead,*varlisttail;

static int skm_func[] = { closepa,begin,semicolon,0 };

SYM *currentfunc=0;

/*      function compilation routines           */
void funcini(void)
{
	currentfunc = 0;
}
void declfuncarg(int isint, int isfar, SYM *sp)
{       char    *names[50];             /* 50 parameters maximum */
        int     nparms, poffset, i, isinline;
        SYM     *sp1, *sp2, *spsave[50], *oldargs=0, *typesp=typequal;
				TYP *temp, *temp1,*todo,*oheadptr;
				char oldeclare[100];
				char *nm;
				if (prm_linkreg && !isint) {
        		poffset = stdretblocksize;            /* size of return block */
						if (isfar)
							poffset += stdintsize ;
				}
				else
        	poffset = 0;            /* size of return block */
        nparms = 0;
				temp = head;
				temp1 = tail;
				oheadptr = headptr;
				todo = sp->tp;
				if (!prm_cplusplus) {
					sp2 = gsearch(declid);
					if (sp2) {
						oldargs = sp2->tp->lst.head;
					}
				}
				todo->lst.head = todo->lst.tail = 0;
				if (lastst == kw_void) {
					getsym();
					if (lastst != closepa) {
						backup(lastst);
						lastst = kw_void;
					}
					else {
						todo->lst.head = (SYM *)-1;
						getsym();
					  goto verify;
					}
				}
				else
					if (lastst == closepa) {
						if (prm_cplusplus)
							todo->lst.head = (SYM *)-1;
						getsym();
						goto verify;
					}
				strcpy(oldeclare,declid);
        if(!prm_cplusplus && lastst == id && 
							((sp1 = search(lastid,gsyms)) ==0 || sp1->storage_class != sc_type) 
							&& ((sp1 = search(lastid,&lsyms)) ==0 || sp1->storage_class != sc_type)) {
              /* declare parameters */
					global_flag = 0;
                while(lastst == id) {
                        names[nparms++] = litlate(lastid);
                        getsym();
                        if( lastst == comma)
                                getsym();
                        else
                                break;
                        }
					global_flag = 1;
                needpunc(closepa,skm_func);
                doargdecl(sc_member,0,0,&todo->lst,isinline = FALSE);      /* declare parameters */
				}
				else {
					doargdecl(sc_member,names,&nparms,&todo->lst,isinline = TRUE);
					needpunc(closepa,skm_func);
				}
				typequal = typesp;
				strcpy(declid,oldeclare);
				if (!ispascal && isstructured(todo->btp))
					poffset += stdaddrsize;
					

        for(i = 0;i < nparms;++i) {
            if ((sp1 = search(names[i],&todo->lst)) == 0 && !isinline)
              sp1 = makeint(litlate(names[i]),&todo->lst);
						if (sp1->tp)
							sp1->tp->uflags |= UF_DEFINED;
						sp1->funcparm = TRUE;
						spsave[i] = sp1;
            sp1->storage_class = sc_auto;
				}
				/*
				 * parameter allocation.  Have to do things backwards if this
				 * function has the pascal declarator
				 */
				if (!ispascal)
        	for(i = 0;i < nparms;++i) {
						sp1 = spsave[i];
						if( sp1->tp->type != bt_pointer && sp1->tp->size < stdintsize)
						{
							sp1->value.i = poffset + funcvaluesize(sp1->tp->size);
							poffset += stdintsize;
						}
						else
						{
							sp1->value.i = poffset;
							if (sp1->tp->type == bt_pointer)
								poffset += stdaddrsize;
							else
								poffset += sp1->tp->size;
						}
					}
				else
        	for(i = nparms-1;i >=0;--i) {
						sp1 = spsave[i];
						if( sp1->tp->type != bt_pointer && sp1->tp->size < stdintsize)
						{
							sp1->value.i = poffset + funcvaluesize(sp1->tp->size);
							poffset += stdintsize;
						}
						else
						{
							sp1->value.i = poffset;
							if (sp1->tp->type == bt_pointer)
								poffset += stdintsize;
							else
								poffset += sp1->tp->size;
						}
					}
				if (!isinline) {
					todo->lst.head = todo->lst.tail = 0;
					for (i=0; i < nparms; i++)
						insert(spsave[i],&todo->lst);
				}
#ifdef CPLUSPLUS
				if (prm_cplusplus && todo->lst.head == 0)
					todo->lst.head = (SYM *) -1; /* () is equiv to (void) in cpp */
#endif
verify:
				head = temp;
				tail = temp1;
				headptr = oheadptr;
#ifdef CPLUSPLUS
				if (prm_cplusplus) {
					return;
				}
#endif
				
				if (oldargs && head->lst.head) {
					SYM *newargs = head->lst.head;
					while (oldargs && newargs) {
						if (oldargs == (SYM *)-1 || newargs == (SYM *)-1)
							break;
						if (!checktype(oldargs->tp,newargs->tp,FALSE))
							gensymerror(ERR_ARGMISMATCH,newargs->name);
						oldargs = oldargs->next;
						newargs = newargs->next;
					}
					if (oldargs && oldargs != (SYM *)-1)
						gensymerror(ERR_ARGLENSHORT,sp->name);
					if (newargs && newargs != (SYM *)-1)
						gensymerror(ERR_ARGLENLONG,sp->name);
				}
				if (sp2 && !checktype(sp2->tp->btp,head->btp,FALSE))
					gensymerror(ERR_DECLMISMATCH,sp2->name);
}
void check_funcused(TABLE *oldlsym, TABLE *lsyms)
{
	/* oldlsym Must BE 0 at the end of a function */
	SYM *sym1;
	if (oldlsym && oldlsym->head == lsyms->head) {
		return;
	}
	sym1 = lsyms->head;
	while (sym1 && (!oldlsym || sym1 != oldlsym->head)) {
		if (sym1->tp->type != bt_func && sym1->tp->type != bt_ifunc
				&& sym1->storage_class != sc_type) {
			if (!(sym1->tp->uflags & UF_USED)) {
				if (sym1->storage_class == sc_label) {
					if (!oldlsym)
						gensymerror(ERR_UNUSEDLABEL,sym1->name);
				}
				else 
					if (sym1->funcparm)
						gensymerror(ERR_PARAMUNUSED,sym1->name);
					else
						gensymerror(ERR_SYMUNUSED,sym1->name);
			}
			if (sym1->tp->uflags & UF_ASSIGNED)
				gensymerror(ERR_SYMASSIGNED,sym1->name);
			if (!oldlsym && sym1->storage_class == sc_ulabel)
				gensymerror(ERR_UNDEFLABEL,sym1->name);
		}
		sym1 = sym1->next;
	}
}
void funcbody(SYM *sp)
/*
 */
{
				SYM *sp1 = sp->tp->lst.head, *sp2;
				varlisthead = 0;
				/* 1 if inline, 0 if local define */
#ifdef CPLUSPLUS
        global_flag = prm_cplusplus && (sp->value.classdata.cppflags & PF_INLINE);
#else
				global_flag = 0;
#endif
				if (sp1 != (SYM *)-1) {
					while (sp1) {
						if (sp1->name[0] != '*') {
							sp2 = xalloc(sizeof(SYM));
							memcpy(sp2,sp1,sizeof(SYM));
							insert(sp2,&lsyms);
						}
						sp1 = sp1->next;
					}
				}
				currentfunc = sp;
        cseg();
				firstlabel = nextlabel;
				if (sp->storage_class == sc_global)
					globaldef(sp);
				goodcode &= ~GF_RETURN;
        block();
				check_funcused(0,&lsyms);
				if (prm_listfile && varlisthead) {
					LIST *q = varlisthead;
      		fprintf(listFile,"\n\n*** local symbol table ***\n\n");
					while (q) {
						SYM *sp = q->data;
						while (sp) {
							list_var(sp,0);
							sp = sp->next;
						}
						q = q->link;
					}
				}
				if (sp->tp->btp->type != bt_void && !(goodcode &GF_RETURN)) 
					generror(ERR_FUNCRETVAL,0,0);
        nl();
				currentfunc = 0;

        release_local();        /* release local symbols */
  			lsyms.head = 0;
				oldlsym.head = oldlsym.tail = 0;
        global_flag = 1;
}

SYM     *makeint(char *name, TABLE *table)
{       SYM     *sp;
        TYP     *tp;
				global_flag++;
        sp = xalloc(sizeof(SYM));
        tp = xalloc(sizeof(TYP));
				global_flag--;
        tp->type = bt_long;
        tp->size = 4;
        tp->btp = tp->lst.head = 0;
        tp->sp = 0;
        sp->name = name;
        sp->storage_class = sc_auto;
        sp->tp = tp;
        insert(sp,table);
        return sp;
}
/* a little ditty to add C++ destructors on the tail of a block
 */
void addrundown(SNODE *snp)
{
	if (block_rundown && snp) {
			SNODE *snp2;
			snp2 = xalloc(sizeof(SNODE));
			snp2->next = 0;
			snp2->stype = st_expr;
			snp2->exp = block_rundown;
			block_rundown = 0;
			while (snp->next)
				snp = snp->next;
			snp->next = snp2;
	}
}
void addblocklist(SYM *sp)
{
	LIST *l;
	if (!sp) return;
	l = xalloc(sizeof(LIST));
	l->link = 0;
	l->data = sp;
	if (varlisthead)
		varlisttail = varlisttail->link = l;
	else
		varlisthead = varlisttail = l;
}
void block(void)
{       
				SNODE *snp3;
				ENODE *obrd = block_rundown;
				ENODE *obrdl = blk_run_link;
				block_rundown = 0;
				block_nesting = 1;
				arg_nesting = 0;
				lastst = 0;
				snp3 = snp_line();
				lastst = begin;
				needpunc(begin,0);
        blockdecl();
				cseg();
				if (snp3)
					snp3->next = compound();
				else
					snp3 = compound();
				addrundown(snp3);
				addblocklist(lsyms.head);
				if (!total_errors) {
#ifdef CPLUSPLUS
					/* this unqualified the current function if it has structured
					 * args or return value, or if it has nested declarations
					 */
					if (currentfunc->value.classdata.cppflags & PF_INLINE) {
						if (isstructured(currentfunc->tp->btp))
							currentfunc->value.classdata.cppflags &= ~PF_INLINE;
						else {
							SYM *head = currentfunc->tp->lst.head;
							while (head) {
								if (isstructured(head->tp)) {
									currentfunc->value.classdata.cppflags &= ~PF_INLINE;
									break;
								}
								head = head->next;
							}
							if (currentfunc->value.classdata.cppflags & PF_INLINE) {
								if (arg_nesting)
									currentfunc->value.classdata.cppflags &= ~PF_INLINE;
							}
						}
					}
					if (currentfunc->value.classdata.cppflags & PF_INLINE) {
						
						currentfunc->value.classdata.inlinefunc = xalloc(sizeof(INLINEFUNC));
						currentfunc->value.classdata.inlinefunc->stmt = snp3;
						currentfunc->value.classdata.inlinefunc->syms = lsyms;
					}
					else
#endif
        		genfunc(snp3);
				}
				block_nesting = 0;
				block_rundown = obrd;
				blk_run_link = obrdl;
}
void gather_labels(TABLE *oldlsym, TABLE *lsyms)
{
	TABLE sym;
	sym.head = 0;
	if (oldlsym->head == lsyms->head) {
		return;
	}
	else {
		SYM *sp = lsyms->head,*r = oldlsym->head;
		lsyms->head = 0;
		while (sp && sp != r) {
			SYM *q = sp->next;
			sp->next = 0;
			if (sp->storage_class == sc_label || sp->storage_class == sc_ulabel) {
				if (!oldlsym->head) {
					oldlsym->head = oldlsym->tail = sp;
				}
				else {
					oldlsym->tail->next = sp;
					oldlsym->tail = sp;
				}
			}
			else
				if (!lsyms->head)
					lsyms->head = lsyms->tail = sp;
				else
					lsyms->tail = lsyms->tail->next = sp;
			sp = q;
		}
		if (oldlsym->tail)
			oldlsym->tail->next = 0;
	}
}
SNODE *compoundblock(void)
{
	SNODE *snp;
	TABLE oldoldlsym;
	SYM *q;
	ENODE *obrd = block_rundown, * obrdl = blk_run_link;
	block_rundown = 0;
	block_nesting++;
	oldoldlsym = oldlsym;
	oldlsym = lsyms;
	blockdecl();
	cseg();
	snp = compound();
	addrundown(snp);
	check_funcused(&oldlsym,&lsyms);
	q = lsyms.head;
	gather_labels(&oldlsym,&lsyms);
	while (q && q->next != oldlsym.head)
		q = q->next;
	if (q) 
		q->next = 0;
	addblocklist(lsyms.head);
	if (oldlsym.head != lsyms.head)
		arg_nesting++;	
	lsyms = oldlsym;
	oldlsym.head = oldoldlsym.head;
	block_nesting--;
	block_rundown = obrd;
	blk_run_link = obrdl;
	return(snp);
}
