

#define  NBLK  0x60

int      ma       = NBLK;
int      curtrack = 0;
int      wsize    = 8208;
int      rsize    = 8208;
int      dstat    = 0;
int      istat    = 0;
char     *header  = "Novell Backup Tape";

int   marktape() {
      return(mtu(0,0,&rsize,3,ma,0,&dstat,&istat));
}

int   skipmarks(num)
int   num;
{
      return(mtu(0,0,&rsize,13,ma,num-1,&dstat,&istat));
}

int   backmarks(num)
int   num;
{
      return(mtu(0,0,&rsize,15,ma,num-1,&dstat,&istat));
}

int   skiprecs(num)
int   num;
{
      return(mtu(0,0,&rsize,12,ma,num-1,&dstat,&istat));
}

int   backrecs(num)
int   num;
{
      return(mtu(0,0,&rsize,14,ma,num-1,&dstat,&istat));
}

int   rewindtape() {
      return(mtu(0,0,&rsize,0x40,ma,0,&dstat,&istat));
}

int   resettape() {
      int   err;

      if (type9())
         ma=0;
      else
         ma=NBLK;
      return (mtu(0,0,&rsize,0x10,ma,0,&dstat,&istat));
/*****
*     curtrack = 0;
*     disp_track(curtrack);
*****/
}

int   seltrack(track) {
      if (type9()) {
         ma=0;
         curtrack=3;                   /*always last track if 9 track*/
      }
      else {
         ma = NBLK + track;
         curtrack = track;
      }
/*****
*     disp_track(curtrack);
*****/
}

int   readtape(rbuf)
int   rbuf;
{
      return(mtu(rbuf,0,&rsize,1,ma,0,&dstat,&istat));
}

int   writetape(wbuf)
int   wbuf;
{
      return(mtu(wbuf,0,&wsize,2,ma,0,&dstat,&istat));
}

int   writestat() {
      return(mtu(0,0,&rsize,0xff,ma,0,&dstat,&istat));
}

int   searchrec(rbuf,rmask)
int   rbuf, rmask;
{
      return(mtu(rbuf,rmask,&rsize,11,ma,0,&dstat,&istat));
}

int   inittape(wbuf)
char  *wbuf;
{
      int   t;
      char  *s1, *s2;

      resettape();
      seltrack(0);
      rewindtape();

      s1=header;
      s2=wbuf;

      while (*s1)
         *s2++ = *s1++;
      *s2=0;
      if (writetape(wbuf))
         return (-1);
      if (marktape())
         return (-1);
      if (marktape())
         return (-1);
      if (!type9())
         for (t=1;t<=3;t++) {
            seltrack(t);
            rewindtape();
            if (marktape())
               return (0xff);
            if (marktape())
               return (0xff);
         }
      seltrack(0);
      rewindtape();
      if (readtape(wbuf))
         return (-1);
      s1=header;
      s2=wbuf;
      while(*s1)
         if (*s1++ != *s2++)
            return (-1);
      return (0);
}

int   checkheader(tbuf)
char  *tbuf;
{
      char  *s1, *s2;

      resettape();
      seltrack(0);
      rewindtape();
      if (readtape(tbuf))
         return(-1);
      s2=tbuf;
      s1=header;
      while ((*s1) &&  (*s1++ == *s2++))
         ;
      if(*s1)
         return (1);
      return (0);
}

int   findEOT(tbuf)
char  *tbuf;
{
      int   lasttrack, EOT, t, ecode;

      EOT = 0;
      lasttrack = 0;
      if(ecode=checkheader(tbuf))
         return (ecode);
      for(t=3;(t>=0) && !lasttrack;t--) {
         seltrack(t);
         rewindtape();
         if (skiprecs(1)) {
            if ((istat & 0x3f) == 0x2e) {
               if (!skiprecs(1)) {
                  lasttrack = -1;
                  if (skipmarks(1))
                     return(-1);
               }
            }
            else
               return(-1);
         }
         else {
            lasttrack = -1;
            rewindtape();
         }
      }
      if (!lasttrack)
         return(-1);
      while (!EOT) {
         if (skipmarks(2))
            return(1);
         backmarks(1);
         if (backrecs(1) && ((istat & 0x3f) == 0x2e))
            EOT = -1;
         else {
            skipmarks(1);
         }
      }
      return (0);
}
