/*****************************************************************************
*
* Base to base conversion with radix conversion program 
* BTBWR - Version 1.0 Beta
* Copyright (C) 1995 Sammy Yousef
* *##################*Use this program at your own risk.*###################*
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
* If you use this program and have any comments feel free to email me. 
* I would be most grateful for any feedback about either the quality of the
* code or the reliability of this program.
*
* Author : Sammy Yousef
*              syousef@socs.uts.edu.au
*              syousef@ghostgum.itd.edu.au
*              sammy@ftoomsh.socs.uts.edu.au
*
*          Also known as Whiteheart and Sam on the talkers.
*
* Date   : 2 August 1995
*
*****************************************************************************/

#include "btb.h"
#include "btbwr.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

/**********************************************************************
* Entry point
***********************************************************************/
int main(int argc, char *argv[])
{
    int args;
    int inbase;
    int outbase;
    char outnum[MAXSTRINGIN];
    int converted;

    if (argc<=3)
	{
	    usage(argv[0]);
	    return(0);
	}
    else
    {
        inbase=atoi(argv[1]);
        outbase=atoi(argv[2]);
        
	for (args=3 ; args<argc ; args++)
	    {
		 if ( btb(inbase,outbase,argv[args],outnum) == 0 )
		     {
			 displaybase(inbase,outbase,argv[args],outnum);
			 converted++;
		     }
		 else
		     {
			 errdisplaybase(inbase,argv[args]);
			 fprintf(stderr,"\Error converting number %s\n\n",argv[args]);
		     }
	    }
    }
    return(converted);
}

/**********************************************************************
* Routines to display output of base conversion program
***********************************************************************/

    /**********************************************************************
    * Displays the base first unconverted then converted to the user
    ***********************************************************************/
    void displaybase(int inbase, int outbase, char innumber[MAXSTRINGIN], 
                    char outnumber[MAXSTRINGIN])
    {    
        printf("(%d) : %s -> (%d) : %s\n",inbase,innumber,outbase,outnumber);
    }
    
    /**********************************************************************
    * Displays the base first unconverted then converted to the user
    ***********************************************************************/
    void errdisplaybase(int inbase, char innumber[MAXSTRINGIN])
    {    
        printf("(%d) : %s -> ?\n",inbase,innumber);
    }
    
    /**********************************************************************
    * Program usage (cutting off program path) for the main program
    ***********************************************************************/
    void usage(char *progname)
    {
        char cutname[100];
        
        /* find the name of the program in DOS or UNIX environments */
        strcpy(cutname, progname);
        
        #if !( defined(__unix__) || defined(__linux__) ) 
        {
            /* remove path in the name in DOS environment */     
            strcpy(cutname, strrchr(progname ,'\\') );
            strcpy(cutname,(char *)(cutname + sizeof(char)) );    
        }
        #endif
            
        printf("Base to Base with Radix Version 1.0 Beta\nCopyright (C) 1995 Sammy Yousef\n");
        printf("This program comes with ABSOLUTELY NO WARRANTY.\n\n");
        printf("Usage : %s [Input base] [Output Base] [[Number 1]...]\n"
                "        Input Base and Output Base must be supplied"
                " in Base 10\n\n"
                "        Eg. To convert 14.5 and 2.25 from base 10 to "
                "base 2 type:\n\n"
                "            %s 10 2 14.5 2.25\n",cutname,cutname);
    }        
        
