#!/bin/sh

AUTO=yes
TESTONLY=no

for PARM in $*
do
    case $PARM in
	--interactive*)
		AUTO=no
		;;
	--test*)
		TESTONLY=yes
		;;
    esac;
done

cp -f /etc/fstab /etc/fstab.ufsd
echo -n >/etc/fstab
while read -a entry;do
    device=${entry[0]}
    mountpoint=${entry[1]}
    type=${entry[2]}
    options=${entry[3]}
    freq=${entry[4]}
    passno=${entry[5]}
    if [[ $options == *dev=ufsd* || $type == *ufsd* ]];then
	    umount $device >/dev/null 2>&1
	    rmdir $mountpoint >/dev/null 2>&1
	    echo "removing line $device $mountpoint $options $type $passno $freq $passno from fstab"
    else
	    #echo "writing $device $mountpoint $type $options $freq $passno"
	    echo "$device $mountpoint $type $options $freq $passno" >>/etc/fstab
    fi
done < /etc/fstab.ufsd

szOSType="unknown"
if [ -x "/sbin/SuSEconfig" ]; then
    if [ -x "`which yast 2>/dev/null`" -o -x "`which yast2 2>/dev/null`" ]; then
	if [ -e "/sbin/init.d" ]; then
		echo "I think you are using a SuSE-like (less 7.1) system"
		szOSType="SuSE70"
	else
	    if [ -e "/etc/init.d" ]; then
		echo "I think you are using a SuSE-like (7.1 or upper) system"
		szOSType="SuSE71"
	    else  
		echo "I think you are using a SuSE-like system"
		szOSType="SuSE"
	    fi
	fi
    fi	    
else
    if [ -x "`which chkconfig 2>/dev/null`" ]; then
	if [ -e "/etc/rc.d/init.d" ]; then
	    echo "I think you are using a Redhat-like system"
	    szOSType="redhat"
	else
    	    echo "I can't recognize your operating system and install services"
	    exit 1
	fi
    else
	if [ -x "`which dpkg 2>/dev/null`" ]; then
	    if [ -e "/etc/init.d" ]; then
		echo "I think you are using a Debian-like system"
		szOSType="debian"
	    fi
	else
	    if [ -e "/etc/rc.d/rc.M" ]; then
		echo "I think you are using a slackware-like system"
		szOSType="slackware"
	    else
		echo "I can't recognize your operating system and install services"
		exit 1
	    fi
	fi
    fi
fi

if [[ "$AUTO" = "no" ]]; then
    echo "Do you want to remove ufsd service?"
    read answer
    case "$answer" in
	y|Y|yes|Yes|YES)
	    echo "Ok. Trying to removing."
	    ;;
	*)
	    echo "Program terminated."
	    exit 1
	    ;;
    esac
fi

if [ $szOSType = "redhat" ]; then
    echo "Removing services for RedHat like system"
    if [ $TESTONLY = "no" ]; then
	if [ -e /etc/rc.d/init.d/ufsd ]; then
	    /etc/rc.d/init.d/ufsd stop
	    chkconfig --del ufsd
	    if [ ! "$?" -eq 0 ]; then
    		echo
    		echo "Can't delete services"
    		echo
	    fi
	    rm -f /etc/rc.d/init.d/ufsd
	fi
    fi
fi

if [ $szOSType = "SuSE70" -o $szOSType = "SuSE71" -o $szOSType = "SuSE" ]; then
    if [ $szOSType = "SuSE71" ]; then
	servicepath="/etc/init.d"
    else
	servicepath="/sbin/init.d"
    fi
    echo "Removing services for SuSE like system"
    if [ -x "`which chkconfig 2>/dev/null`" ]; then
	if [ $TESTONLY = "no" ]; then
	    if [ -e /etc/rc.d/init.d/ufsd ]; then
		/etc/rc.d/init.d/ufsd stop
		chkconfig --del ufsd
		if [ ! "$?" -eq 0 ]; then
    		    echo
    		    echo "Can't delete services"
    		    echo
		fi    
		rm -f $servicepath/ufsd
	    fi
	fi    
    else
	if [ $TESTONLY = "no" ]; then
	    rm -f $servicepath/rc2.d/K14ufsd
	    rm -f $servicepath/rc2.d/S08ufsd
	    rm -f $servicepath/rc3.d/K14ufsd
	    rm -f $servicepath/rc3.d/S08ufsd
	    rm -f $servicepath/rc5.d/K14ufsd
	    rm -f $servicepath/rc5.d/S08ufsd
	    rm -f $servicepath/ufsd
	fi 
    fi
fi

asktoremove=no
if [[ "$AUTO" = "no" ]]; then
    echo "Do you want to remove ufsd module for all your kernels?"
    read answer
    case "$answer" in
	y|Y|yes|Yes|YES)
	    echo "Ok. Trying to removing."
	    ;;
	*)
	    asktoremove=yes
	    ;;
    esac
fi

while read -a entry;do
    device=${entry[0]}
    mountpoint=${entry[1]}
    type=${entry[2]}
    options=${entry[3]}
    freq=${entry[4]}
    passno=${entry[5]}
    if [[ $options == *dev=ufsd* || $type == *ufsd* ]];then
	umount $device >/dev/null 2>&1
	echo "umounting $device (mounted on $mountpoint with options $options)"
    fi
done < /proc/mounts

for path in /lib/modules/*
do
    if [ -d $path/kernel/fs/ufsd ]; then
	if [[ "$asktoremove" = "yes" ]]; then
	    echo "Do you want to remove ufsd module in directory $path?"
	    read answer
	    case "$answer" in
		y|Y|yes|Yes|YES)
		    echo "Ok. Trying to removing."
		    /sbin/rmmod ufsd >/dev/null 2>&1
		    rm -rf $path/kernel/fs/ufsd
		    ;;
	    esac
	else
	    /sbin/rmmod ufsd >/dev/null 2>&1
	    rm -rf $path/kernel/fs/ufsd
	fi
    fi
done

echo "Finding module dependencies..."
/sbin/depmod >/dev/null 2>&1
