#include "graphics.h"
#include "outmsg.h"
#include <alloc.h>

struct imageBuf { int x1,y1,x2,y2;
                  char buf[2];
                };

/*=================================================================*/
void  far pascal Outmsg( const char far *msg1, const char far *msg2,
                         void far* far* imagePtr )
/*=================================================================*/
/* This procedure displays on graphic screen two lines with
	msg1 and msg2 texts respectivly.
	If imagePtr is not NIL it also allocates memory and saves
	overwitten part of screen in that memory. Pointer to allocated
	memory is returned in *imagePtr variable. You may use CloseOutMsg
	procedure to restore screen contents and free the memory
 */
{
   int   h,w,x1,y1,x2,y2;
   struct textsettingstype ts;
   struct viewporttype     vp;

   gettextsettings(&ts);
   getviewsettings(&vp);

   settextstyle(DEFAULT_FONT,HORIZ_DIR,2);
   settextjustify(CENTER_TEXT,TOP_TEXT);
   h=textheight(msg1);
   w=textwidth(msg1);
   if ( h<textheight(msg2) ) h=textheight(msg2);
   if ( w<textwidth(msg2) ) w=textwidth(msg2);
   h +=15;
   w +=16;
   x1=(getmaxx()-w)/2-8; y1=getmaxy()/2-h-8;
   x2=(getmaxx()+w)/2+8; y2=getmaxy()/2+h+8;
   if ( imagePtr!=NULL )
   {  struct imageBuf  far *p;
      unsigned   s;
      *imagePtr=NULL;
      if ( (s=imagesize(x1,y1,x2,y2)) < 0xfff0 )
      {
         if ( (p=(struct imageBuf*)farmalloc(s+8))!=NULL )
         {
            getimage(x1,y1,x2,y2,p->buf);
            p->x1=x1; p->y1=y1;
            p->x2=x2; p->y2=y2;
            *imagePtr=p;
         }
      }
   }
   setviewport( x1,y1, x2, y2, 1);
   setcolor(getmaxcolor());
   setfillstyle(SOLID_FILL,BLACK);
   clearviewport(); // bar(0,0,w,2*h);
   rectangle(0,0,w+16,2*h+16);
   setviewport( x1+8,y1+8, x2-8, y2-8, 1);
   rectangle(0,0,w,2*h);
   outtextxy(w/2,5, msg1);
   outtextxy(w/2,10+h, msg2);

   settextstyle(ts.font,ts.direction,ts.charsize);
   settextjustify(ts.horiz,ts.vert);
   setviewport(vp.left,vp.top, vp.right,vp.bottom, vp.clip);
}

/*=====================================================*/
void  far pascal CloseOutmsg( void far* far* imagePtr )
/*=====================================================*/
{
   if ( imagePtr!=NULL && *imagePtr!=NULL )
   {  struct imageBuf  far *p;
      p=(struct imageBuf*)*imagePtr;
      putimage(p->x1,p->y1,p->buf,COPY_PUT);
      farfree(p);
      *imagePtr=NULL;
   }
}

