/* Listing 1 -- PROLOG MAIN MODULE */

global predicates
   draw_bar(integer,integer,integer,integer) - 
        		       (i,i,i,i) language c
   clear_screen language c
   remove_cursor language c
   draw_axis language c
   restore_cursor language c

predicates
   main
   process
   set_up_bar(integer,integer,integer,integer,real)

goal                             /* PROLOG module must contain */
   main.	                 /* a GOAL in order to compile */
		                 /* to .OBJ. */

clauses
   main:-                         /* Set up user interface. */
      makewindow(1,7,7,"Graphics",0,0,25,80),
      process.                  /* Process the problem. */
   main:-                         /* Continue? */
      write("Do you want to continue? y or n"),
      readchar(Answer), Answer = 'y',
      main.                     /* Call main recursively. */
   main:-	 		  /* We're done. */
      nl,write("Press any key to end."),
      readchar(_),		    
      clear_screen(),		  /* Clean up for next applic.*/
      restore_cursor().

   process:-			  /* Process the problem. */
      write("Enter the number of bars: "), 
      readint(NumOfBars),
      clearwindow,
      NumOfBars <= 10,          /* The system is currently */
                                /* set up to handle 10 bars.*/
      write("Enter max value on Y scale: "),
      readint(Max),
      Max > 0,                  /* Avoid division by zero. */
      clearwindow,
      YScale = 18/Max,          /* Our axis is currently set */
				  /*   up as 18 by 60. */
      Width = 60/NumOfBars,
      Xstart = 2,		  /* Start the first bar next */
				  /*   to the y axis. */
      clear_screen(),           /* Call C functions. */
      remove_cursor(),          /* Who needs it? */
      draw_axis(),
      Num = 1,                  /* Set Num for first bar. */
				  /* And begin. */
      set_up_bar(Num,NumOfBars, Width, Xstart, Yscale),
      fail.                     /* Fail when we're finished */
				  /*  and reclaim memory. */
			
				  /* Error report. */
   process:-		
      write("System is currently set up to draw 10 bars"),
      write(" & Y > 0, <= 30,000 max."),
      nl, fail. 		
 	 		
   set_up_bar(0,_,_,_,_):-!.         /* There are no bars to */
				  /* process, so we're done. */
   set_up_bar(Num,NumOfBars,Width,Xstart,Yscale):-
      Num <= NumOfBars,         /* Are we done? */
      write("Enter the value for bar ",Num ,": "),
      readint(Y),
      Height=Y*YScale,          /* Calculate height of bar. */
			          /* Call C function to draw. */
      Height <= 18,             /* Value <= Y max? */
      draw_bar(Num,Xstart,Height,Width),
				  /* Get next x position. */
      XNewPos= Xstart + Width + 1,
      XNuNew=Num + 1,           /* Keep count of bars. */
				  /* Continue getting bar */ 
				  /* values until we're done. */
      !,set_up_bar(XNuNew,NumOfBars,Width,XNewPos,Yscale).
   set_up_bar(Num,NumOfBars,_,_,_):-
      Num >= NumOfBars,!.         /* We're done. */
   set_up_bar(Num,NumOfBars,_,_,_):-
      Num <= NumOfBars,         /* There's an input error. */
      write("Bar value exceeds Y max."),
      !.

