;Timeboot : TSR to reboot after n minutes after installation
;(where n can be 1..9).
;Given to the public domain
;David Kirschbaum
;Toad Hall
;kirsch@usasoc.soc.mil

CR	EQU	0DH
LF	EQU	0AH
JMP_FAR	EQU	0EAH

PAGE_0	SEGMENT	AT 0
	ORG	472H
Boot_Flag	dw	?		;Warm boot flag
PAGE_0	ENDS

CSEG	SEGMENT PUBLIC PARA 'Code'
	ASSUME	CS:CSEG,DS:CSEG
	org	0
BeginCode	equ	$

	org	80H
cmdlen	label	byte
	org	82H
cmdparm	label	byte			;nr of seconds
	org	100H			;.COM program

TimeBoot PROC	NEAR
	jmp	Start			;skip over runtime code

ticks	dw	0			;delay in timer ticks

TimeBoot ENDP

;Our new clock interrupt
NewInt1C	PROC	FAR
	ASSUME	DS:NOTHING

	cmp	CS:ticks,0		;timed out?
	jz	Timed_Out		;yep, it's Party Time!
	 dec	CS:ticks		;count down
;	 jmp	CS:oldInt1C		;'Well-behaved' programming
					;vs. 'feelthy code'
	db	JMP_FAR			;JMP FAR instruction
oldInt1C	LABEL	DWORD
ofs_Int1C	dw	0
seg_Int1C	dw	0

Timed_Out:
	xor	ax,ax			;Page 0
	mov	DS,ax			;point DS to memory base
	ASSUME	DS:PAGE_0

	mov	Boot_Flag,1234H		;flag DOS to warm boot
;	jmp	CS:Restart		;go reboot
	db	JMP_FAR			;JMP FAR instruction
Restart  LABEL	DWORD
;according to REBOOT.ASM, reboot IP and CS should be this:
;	dw	0E05BH			; IP for reboot
;	dw	0F000H			; CS for reboot
;according to WARMBOOT.COM's disassembly, it should be this:
	dw	0000H			; IP for reboot
	dw	0FFFFH			; CS for reboot

NewInt1C	ENDP
EndCode	equ	$			;last of TSR code

	ASSUME	DS:CSEG
Start	PROC	NEAR

	call	GetTime			;get timeout in minutes from cmdline
					;(may die)
	mov	cx,1092	;60*18.2	;one minute in timer ticks
	xor	dx,dx			;insure DX clear
	mul	cx			;AX = timer ticks
	mov	ticks,ax		;save the timeout value locally

	mov	ax,351CH		;get Int 1CH timer int vector
	int	21H
	mov	ofs_Int1C,bx		;save offset
	mov	seg_Int1C,ES		;and segment

	mov	dx,offset NewInt1C	;our new interrupt service
	mov	ax,251CH		;set new 1CH timer int vector
	int	21H
	mov	dx,offset installed$	;'TimeBoot installed ...'
	mov	ah,9			;display msg
	int	21H

;compute amount of memory to retain when going TSR (in paras)

	mov     dx,(EndCode-BeginCode+0Fh) SHR 4	;memory to retain
	mov	ah,31H			;go TSR
	int	21H

Start	ENDP

GetTime	PROC	NEAR
	cmp	cmdlen,2		;should be 2 char cmdline
	jnz	Usage			;nope, tell the dummy how
	mov	al,cmdparm		;get the nr of minutes
	cmp	al,'1'			;check for 1..9 minutes
	jb	Usage
	cmp	al,'9'
	ja	Usage
	 mov	delay,al		;stuff in msg
	 sub	al,'0'			;deasciify
	 xor	ah,ah			;clear msb
	 ret				;return with minutes in AL

Usage:	mov	dx,offset usage$	;How to
	mov	ah,9			;display msg
	int	21H
	mov	ax,4C01H		;terminate, ERRORLEVEL 1
	int	21H
GetTime	ENDP

usage$	db	'TIMEBOOT v1.0 (Toad Hall)',CR,LF
	db	'Usage:  TIMEBOOT n',CR,LF
	db	'Where n is the number of minutes delay before a warm boot.'
	db	CR,LF,'$'

installed$ db	'TIMEBOOT installed for '
delay	db	'n minutes delay.',CR,LF,'$'

CSEG	ENDS
	END	TimeBoot
