/*
   Module:  hpparms.h
   Date:    3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file ADI7221.DOC.

   Purpose: This module provides the function prototupes for the functions 
            required to convert ADI code arguments to HP parameter codes.

   Functions provided:

        uinttosbn    (unsigned int to Single Byte Number)
        uiptombp     (unsigned int pair to Multiple Byte Pair)
*/

#define MAXMBPLEN 5  /* maximum length of a Multiple Byte Pair */

/*
   Function: uinttosbn
   Purpose:  Convert an unsigned int to an HP Single Byte Number.

   Pre: numin is the number to convert.
        0 <= numin <= 63
        sbnout is a pointer to storage for the converted Single Byte Number.

   Post: An attempt is made to convert numin to SBN format and copy the
         retult to sbnout.
         If an error occurs (ie numin is out of range), FALSE is returned.
         Otherwise, TRUE is returned.
*/

int uinttosbn (unsigned numin, char *sbnout);



/*
   Function: uiptombp
   Purpose: Convert a pair of unsigned ints to an HP Multiple Byte Pair.

   Pre: num1 and num2 comprise the pair of numbers to be converted to an
        HP MBP.
        0 <= num1,num2 <= 16383
        mbpout is a pointer to storage for the converted code.
        mbpout points to enough storage to hold the maximum size of a mbp
        formatted code (MAXMBPLEN).
        mbpsize is a pointer to storage for the number of bytes actually
        placed in mbpout.

   Post: an attempt is made to convert num1 and num2 to MBP format and copy
         the result to mbpout.
         The number of bytes in mbpout is returned in mbpsize.
         If an error occurs (num1 or num2 are out of range), FALSE is
         returned.
         Otherwise, TRUE is returned.

*/

int uiptombp (unsigned num1, unsigned num2, char *mbpout, int *mbpsize);
