/****************************************************************

	sfsx_var.c      Global Variables
			for Space Flight Simulator,
			Simulation Module

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

****************************************************************/

#include "sfsx.h"

long    sfs_insertion;          /* Moment of orbital insertion */
long    sfsx_epoch;             /* Orbital epoch in seconds since beginning */
long    sfs_tfactor;            /* time factor  */
int     sfs_display = 0;        /* Screen:  0 = visual simulation at top   */
				/*          1 = distant perspective at top */
				/*          2 = zoom (full) visual         */

struct sfs_orbit *sfsx_orbits[ ORBITS ];
				/* Structures for orbital data */
char    sfsx_tbuf[ 256 ];       /* a scratch buffer */

char    bw_ebuf[ BW_EBUFSIZE ];

int     al_hor, al_vert;
long    sfsx_dp;
long    sfs_inc;

struct spj_pt spd_start, spd_end;       /* surface data pointers */
struct spj_pt gr_start, gr_end;         /* grid data pointers */
struct spj_pt pd_start, pd_end;         /* point data pointers */
struct spj_pt or_start, or_end;         /* orb data pointers */

struct as_focus sfsx_focus;             /* orbital focus structure */
char sfsx_gridfile[ 32 ];               /* grid spd file */

int cp_height, cp_space, cp_center;

char sp_tbuf[ 64 ];

int     gt_color;       /* Color for ground track plot          */

char    pd_name[ 128 ];
char    pd_file[ 32 ];

char    pr_name[ 128 ];
int     sfsx_display = 0;       /* Screen:  0 = visual simulation in top   */
				/*          1 = distant perspective in top */
				/*          2 = zoom (full) visual         */


struct  uiwindow *main_window;          /* structure for main window    */
struct  uiwindow *po_window;            /* structure for focus panel    */
struct  uiwindow *ti_window;            /* structure for relation window */
struct  uiwindow *sy_window;            /* structure for timing window  */
struct  uiwindow *cp_window;            /* structure for control panel box */
struct  uiwindow *fo_window;            /* structure for focus window   */
struct  uiwindow *z_window;             /* structure for zoom window   */
struct  uiwindow *t_window;             /* top window */
struct  uiwindow *b_window;             /* bottom window */

int     help_y1;                        /* line for help display      */
int     help_y2;                        /* top of help display        */
int     help_x1;                        /* column for help display    */
int     help_x2;                        /* max col for help display   */

/*	Colors */

int	cl_mback;		/* Main background color	*/
int	cl_mfore;		/* Main foreground color	*/
int	cl_marker;		/* Color for prompt markers	*/
int	cl_grid;		/* Color for planetary grid	*/
int	cl_surface;		/* Color for planetary surface	*/
int	cl_orbits[ 6 ];		/* Colors for different orbits	*/


