/*************************************************************************

	kb_cpm.c	Keyboard (KB) Subroutines
		   	for Bywater Software

			Implementation for CP/M computers
			(should work on all CP/M 2.2 machines).
			utilizing the Eco-C (tm) compiler 

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	WARNING:        THIS IS AN OUTMODED FILE, unused in most
			recent versions of this software, or not
			yet updated and verified to latest revision
			levels. Use at your own risk. It should not
			be distributed publicly.

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

**************************************************************************/

#include "kb.h"

#ifndef CR
#define	CR	0x0d
#define LF	0x0a
#define	ESC	0x1b
#endif

#define	DELBACK	0x08

int cpm_hold = 0;

/*************************************************************************

	FUNCTION:       kb_init()

	DESCRIPTION:    This function should perform any initialization
			necessary for the keyboard system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_init()
	{
	}

/*************************************************************************

	FUNCTION:       kb_deinit()

	DESCRIPTION:    This function should perform any necessary
			deinitialization, that is, return the keyboard
			to its default state when a Simple Software
			program is to be exited.

	INPUT:          none.

	RETURNS:        none.

**************************************************************************/

kb_deinit()
	{
	}

/*************************************************************************

	FUNCTION:       kb_cis()

	DESCRIPTION:    This function determines whether a character is
			ready from the console.  The function is used
			especially in telecommunications programs,
			where it is necessary to poll the keyboard
			without locking up the program waiting for a
			response.

	INPUT:          none.

	RETURNS:        The function returns 0 if no character is
			available and 1 if a character is available.

**************************************************************************/

kb_cis()
	{
	register int c;
	if ( ( c = _bdos( 0x06, 0xff ) ) == 0 )
		{
		cpm_hold = 0;
		return 0;
		}
	else
		{
		cpm_hold = c;
		return 1;
		}
	}

/*************************************************************************

	FUNCTION:       kb_ci()

	DESCRIPTION:    This function returns a single character from
			the keyboard.  If a character is not available
			it waits.  The function should be able to
			recognize any special keys, and return the
			appropriate Simple Software KB conventions
			designated for them.

	INPUT:          none.

	RETURNS:        The function returns the ASCII code for the
			key pressed, or the Simple Software KB convention
			(see kb.h) for a function or other special key.

**************************************************************************/

kb_ci()
	{
	int c;
	if ( cpm_hold != 0 )
		{
		c = cpm_hold;
		cpm_hold = 0;
		return c;
		}
	while ( ( c = _bdos( 0x06, 0xff )) == 0 )
		;
	if ( ( c >= 0x20 ) && ( c < 0x7f ) )
		{
		return c;
		}
	else
		{
		switch ( c )
			{
			case 0x05:
				return KB_UP;
				break;
			case 0x18:
				return KB_DOWN;
				break;
			case 0x13:
				return KB_LEFT;
				break;
			case 0x04:
				return KB_RIGHT;
				break;
			case 0x12:
				return KB_P_UP;
				break;
			case 0x03:
				return KB_P_DOWN;
				break;
			case 0x16:
				return KB_INSERT;
				break;
			case 0x07:
				return KB_DELETE;
				break;
			case 0x01:
				return KB_FK3;
				break;
			case 0x06:
				return KB_FK4;
				break;
			case 0x19:
				return KB_FK5;
				break;
			case 0x14:
				return KB_FK6;
				break;
			case 0x0b:
			case ESC:
				return cpm_esc();
				break;
			case CR:
			case LF:
			case DELBACK:
				return c;
				break;
			default:
				return 0;
				break;
			}
		}
	}

/*************************************************************************

	FUNCTION:       cpm_esc()

	DESCRIPTION:    This function handles escape sequences from the
			keyboard.  It calls the kb_emenu() function
			(defined by the application program), accepts
			a new command letter, then replace the menu
			with kb_dmenu (the default menu defined by
			the application program).

	INPUT:          none.

	RETURNS:        The function returns the Simple Software
			convention for a special key sequence (see
			kb.h), or 0.

**************************************************************************/

cpm_esc()
	{
	register int c;
	while ( ( c = _bdos( 0x06, 0xff ) ) == 0 )
		;
	switch ( c )
		{
		case '1':
			return KB_FK1;
			break;
		case '2':
			return KB_FK2;
			break;
		case '3':
			return KB_FK3;
			break;
		case '4':
			return KB_FK4;
			break;
		case '5':
			return KB_FK5;
			break;
		case '6':
			return KB_FK6;
			break;
		case '7':
			return KB_FK7;
			break;
		case '8':
		case 'Q':
		case 'q':
			return KB_FK8;
			break;
		case '9':
		case 'S':
		case 's':
			return KB_FK9;
			break;
		case '0':
		case 'D':
		case 'd':
			return KB_FK10;
			break;
		default:
			return 0;
			break;
		}
	}

