/********************************************************
   N-Body Globular Cluster COMMAND LINE ARGUMENT PARSER
   This File (C) Copyright 1998 Graeme Fenwick
********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "gl.h"
#include "gl_arg.h"

int  argparse_numscan(char *, int *, double *);    /* only used in this file */
void info(int exval);                                               /* ditto */

/********** ARGument PARSEr parent function */

void argparse(int argc, char **argv, int *n, SETTINGS *config)
{
   int      pint, sw_chr;                     /* pint = generic +ve integer */
   double   pdbl;                              /* pdbl = generic +ve double */

   for ( ; argc > 1; --argc) {
      if (argv[argc - 1][0] != '/' || strlen(argv[argc-1]) < 2)
         info(1);                                 /* immediate arg rejection */
      sw_chr = toupper(argv[argc - 1][1]);
      argparse_numscan(argv[argc - 1] + 2, &pint, &pdbl);    /* find numbers */
      switch(sw_chr) {                               /* alter config setting */
      case '?':                                         
         info(0);                           
      case 'E':                                     
         config -> e_disp = 1;
         break;
      case 'P':                                          
         config -> p_source = 1;
         break;
      case 'T':
         config -> trails = 1;
         break;
      case 'A':
         if (pdbl > 0) {
            config -> timestep = pdbl;
            break;
         }
         else
            info(1);
      case 'M':
         if (pdbl > 0) {
            config -> totmass = pdbl;
            break;
         }
         else
            info(1);
      case 'Z':
	 if (pdbl > 0) {
            config -> size = pdbl;
            break;
         }
         else
            info(1);
      case 'S':
         if (pint >= 1) {
            config -> seed = pint;
            break;
         }
         else
            info(1);
      case 'N':
         if (pint >= 1) {
            *n = pint;
            break;
         }
         else
            info(1);
      case 'R':
	 if (pint >= 1) {
            config -> runtime = pint;
            break;
         }
         else
            info(1);
      case 'D':
         if (pint >= 20) {
            config -> cndist = pint;
            break;
         }
         else
            info(1);
      default:
         info(1);                         /* user has entered an invalid arg */
      }
   }
}

/********** ARGument PARSEr- NUMeric SCAN
            (Takes part of arg from : onwards and tries to get numbers) */

int argparse_numscan(char *parstr, int *pint, double *pdbl)
{
   int   scanned;

   if (parstr[0] != ':') {                /* numbers must be preceded by ':' */
      *pdbl = *pint = -1;                          /* assigned "fail" values */
      return 0;
   }
   scanned = sscanf(parstr + 1, "%d", pint);
   if (scanned == 0 || scanned == EOF || *pint <= 0)   /* can't scan +ve int */
      *pint = -1;
   scanned = sscanf(parstr + 1, "%lf", pdbl);
   if (scanned == 0 || scanned == EOF || *pdbl <= 0.0)  /* can't scan +ve db */
      *pdbl = -1.0;
   return ((*pint >= 1) + (*pdbl > 0.0));       /* return no. of conversions */
}

/********** Display INFO message
            (Displays Error message if nonzero passed and exits abnormally) */ 

void info(int exval)
{
   if (exval == 1)                             /* wrong argument was entered */
      fprintf(stderr, "%s\n%s\n\n",
         "Invalid Switch or Switch Value.",
         "Usage is as follows :-");
   else
      fprintf(stderr, "%s\n\n",
         "Simulates gravity and forces of a pseudo-random group of bodies.");
   fprintf(stderr, "%s\n\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n\n%s\n%s\n",
    "GLOBULAR [/E] [/P] [/T] [/N:x] [/M:x] [/R:x] [/D:x] [/Z:x] [/S:x] [/A:x]",
    "  /E    Energy and Status Display On                  Default  Off",
    "  /P    Point Sources                                          Off",
    "  /T    Leave Trails                                           Off",
    "  /N:x  Number of Bodies                                       150",
    "  /M:x  Total Mass of System                                   3.0",
    "  /R:x  Running Time (Actual Seconds)                          25",
    "  /D:x  Distance from Globular Centre                          250",
    "  /Z:x  Apparent Size of Bodies (Not Point Source)             2.0",
    "  /S:x  Random Number Seed (Integer >= 1)                      1",
    "  /A:x  Accuracy of Timesteps                                  0.02",
    "Full documentation and source code should either be supplied with this",
    "program, or available from the same place.");
   exit((exval == 0) ? EXIT_SUCCESS : EXIT_FAILURE);
}

