; This program is made by Daniel Horchner.
; email: dbjh@gmx.net

        .386p
        locals

code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

NO_EXTERN       =       0
include ..\raw32.inc
include raw32mod.inc

;32-bit data
videodsc        seg_descriptor  <,,, 10010010b, 10000000b,>
videosel        dw      0

VBE_InfoStruc   struc
VBE_Signature   db      'VBE2'          ; Indicate VBE 2.0 info is desired
                db      14 dup(0)       ; Not interested in...
TotalMemory     dw      0
                db      492 dup(0)      ; Not interested in...
VBE_InfoStruc   ends
VBE_Info        VBE_InfoStruc   <>

ModeInfoStruc   struc
ModeAttributes  dw      0
                db      38 dup(0)       ; Not interested in...
PhysBasePtr     dd      0
                db      212 dup(0)      ; Not interested in...
ModeInfoStruc   ends
ModeInfo        ModeInfoStruc   <>

VidMode         dw      101h            ; 640x480x256
msg0            db      'VBE error.','$'
msg1            db      'No linear framebuffer available.','$'
msg2            db      'Mapping error.','$'

;32-bit code
main:
        mov eax,512                     ; Allocate 512 bytes for VBE info
        call getlomem                   ;  structure, must be in low memory
        add eax,code32a
        push eax                        ; Save pointer to buffer
        mov dl,al
        and edx,0fh
        shr eax,4
        mov v86r_es,ax
        mov v86r_di,dx
        mov v86r_ax,4f00h
        mov al,10h
        int RMCALL_VECT
        call check_error
        jc @exit

        mov es,data32sel
        mov ds,zerosel
        mov esi,[esp]                   ; Don't POP, buf ptr will be reused
        mov edi,offset VBE_Info
        mov ecx,512/4
        rep movsd                       ; Copy VBE info struc to 'VBE_Info'

        mov ds,cs:data32sel
        mov eax,[esp]                   ; ptr will be used one more time
        mov dl,al
        and edx,0fh
        shr eax,4
        mov v86r_es,ax
        mov v86r_di,dx
        mov v86r_ax,4f01h
        mov cx,VidMode
        mov v86r_cx,cx
        mov al,10h
        int RMCALL_VECT
        call check_error
        jc @exit

        mov ds,zerosel
        pop esi
        mov edi,offset ModeInfo
        mov ecx,256/4
        rep movsd                       ; Copy Mode info struc to 'ModeInfo'
        mov ds,cs:data32sel

        test ModeInfo.ModeAttributes,80h
        mov edx,offset msg1
        jz errexit                      ; bit 7=1 -> Linear frame buf avail

                                        ; Set up the descriptor fields
        movzx eax,VBE_Info.TotalMemory  ; VBE returns # 64KB mem blocks
        shl eax,16                      ; amount video mem in bytes
        dec eax                         ; limit=size-1
        shr eax,12                      ; video mem in 4KB units
        mov videodsc.limit0_15,ax
        shr eax,8
        and ah,0fh
        or videodsc.gx00limit16_19,ah   ; Who has got a PC with > 256MB VRAM?

        movzx eax,VBE_Info.TotalMemory
        shl eax,16
        mov edx,ModeInfo.PhysBasePtr
        call map_phys_addr
        push edx                        ; Save linear address for if no error
        mov edx,offset msg2
        jc errexit
        pop edx

        mov videodsc.base0_15,dx        ; edx=lin addr to access phys memory
        shr edx,16
        mov videodsc.base16_23,dl
        mov videodsc.base24_31,dh

        mov ebx,cs
        lar ecx,ebx
        and ecx,6000h                   ; Only the DPL bits are needed
        or videodsc.access,ch           ; Set the DPL bits to the CPL

        mov cx,1                        ; Allocate 1 descriptor
        call getdsc
        jc @exit
        mov videosel,ax

        mov es,bx                       ; es:edi=pointer to 8 byte dsc buffer
        mov edi,offset videodsc
        mov bx,videosel                 ; bx=selector
        call setdsc                     ; Set descriptor
        jc @exit

        mov v86r_ax,4f02h               ; Set VBE mode
        mov ax,VidMode
        mov v86r_bx,ax
        or v86r_bx,4000h                ; bit 14=1 -> Use linear frame buffer
        mov al,10h
        int RMCALL_VECT
        call check_error
        jc @exit

        mov es,videosel                 ; Fill one screen
        mov ebx,640*480
@@next_pixel:
        mov es:[ebx-1],bl
        dec ebx
        jnz @@next_pixel

        mov v86r_ah,0                   ; ah=0 -> Wait for key and read char
        mov al,16h
        int RMCALL_VECT
        mov v86r_ax,3                   ; Set video mode 3 (text 80x25x16)
        mov al,10h
        int RMCALL_VECT

@exit:
        jmp exit                        ; Return to real/V86 mode
errexit:
        call dosprintx
        jmp exit

check_error:
        clc
        cmp v86r_ah,0
        je @@exit
        mov edx,offset msg0
        call dosprintx
        stc
@@exit:
        ret

;
; Print '$' terminated string via DOS
; In:
;   ds = data32sel
;   edx = offset of '$' terminated string
;
dosprintx:
        push eax ecx esi edi es
        mov ax,ds                       ; First, get string length
        mov es,ax                       ; es=ds for scasb
        mov edi,edx
        mov ecx,0ffffffffh              ; Search max 4GB
        mov al,'$'                      ; Scan for '$' (=end of DOS string)
        cld
        repne scasb                     ; Compare al with es:edi
        not ecx
        mov eax,ecx                     ; ecx=string length (including '$')
        push lomembase
        call getlomem
        mov esi,edx
        mov edi,eax
        add edi,code32a
        mov es,zerosel
        cld
        rep movsb
        mov edx,eax
        call dosprint
        pop lomembase
        pop es edi esi ecx eax
        ret

code32  ends
        end     main
