; Original TASM code written by Tran
; Ported to NASM by Ike (a.k.a. Ivan Tomac)

%include "pmode.inc"

global  _kbtbl0
global  _kbtbl1
global  _kbchar
global  _kbshift
global  _kbhit

global  _initkb
global  _resetkb
global  _getch
global  _clearkb

opmirq1         dd      0               ; old IRQ1 vektor
ormirq1         dd      0               ; old real mode IRQ1 vektor

_kbtbl0         times 80h db    0       ; non-sticky keyboard table
_kbtbl1         times 80h db    0       ; sticky keyboard table
_kbchar         db      0               ; last key that was hit
_kbshift        db      0               ; shift states for lask key
_kbhit          db      0               ; 0=no key hit, 1=key hit available

kbrmirqbuf      times 21 db     0

kbxtbl          db      0,14,'1234567890-=',16,15,'qwertyuiop[]',13,0
                db      "asdfghjkl;'`",0,'\zxcvbnm,./',0,'*',0,32,0
                db      1,2,3,4,5,6,7,8,9,10,0,0,19,25,21,'-',23,'5'
                db      24,'+',20,26,22,17,18,0,0,0,11,12
                times 27h db    0
                db      0,14,'!@#$%^&*()_+',16,15,'QWERTYUIOP{}',13,0
                db      'ASDFGHJKL:"~',0,'|ZXCVBNM<>?',0,'*',0,32,0
                db      1,2,3,4,5,6,7,8,9,10,0,0,19,25,21,'-',23,'5'
                db      24,'+',20,26,22,17,18,0,0,0,11,12
                times 27h db    0

irq1:
        push eax
        push ebx
        push ds
        mov ds,[cs:_seldata]
        in al,60h
        movzx ebx,al
        btr ebx,7
        setnc al
        mov [_kbtbl0+ebx],al
        or [_kbtbl1+ebx],al
        or al,al
        jz short irq1d
        mov ah,[_kbtbl0+2ah]
        or ah,[_kbtbl0+36h]
        mov bh,ah
        shl bh,7
        add bl,bh
        movzx ebx,bl
        mov al,[kbxtbl+ebx]
        or al,al
        jz short irq1d
        mov [_kbchar],al
        mov BYTE [_kbhit],1
        mov al,[_kbtbl0+1dh]
        shl al,1
        or al,[_kbtbl0+38h]
        shl al,1
        or al,ah
        mov [_kbshift],al
irq1d:
        pop ds
        pop ebx
        mov al,20h
        out 20h,al
        pop eax
        sti
        iretd

;
; Initialize keyboard handler
; Out:
;   EAX,BX,EDX,EDI - ?
;

_initkb:
        mov bl,1
        call [_getirqvect]
        mov [opmirq1],edx
        mov edx,irq1
        call [_setirqvect]
        mov edi,kbrmirqbuf
        call _rmpmirqset
        mov [ormirq1],eax
        ret

;
; Reset keyboard handler
; Out:
;   EAX,BX,EDX - ?
;

_resetkb:
        mov bl,1
        mov eax,[ormirq1]
        call _rmpmirqfree
        mov edx,[opmirq1]
        jmp [_setirqvect]

;
; Get the last character pressed
; Out:
;   AL - case adjusted character
;   AH - shift state bits: 0=SHIFT, 1=ALT, 2=CTRL
;

_getch:
        cmp BYTE [_kbhit],0
        je _getch
        mov BYTE [_kbhit],0
        mov ax,word [_kbchar]
        ret

;
; Clear all kb stuff
; Out:
;   EAX,ECX,EDI - ?
;

_clearkb:
        mov edi,_kbtbl0
        xor eax,eax
        mov ecx,40h
        rep stosd
        mov BYTE [_kbshift],0
        mov BYTE [_kbhit],0
        ret
