
; This program sets up a simple little protected mode handler for the timer
;  IRQ 0. It just flashes a '0' then a '1' in the upper right corner of the
;  screen.

%include "pmode.inc"

_main:
                sti

                mov     bl,0                    ; get and store old IRQ 0 vector
                call    [_getirqvect]
                push    edx
                mov     edx,pmirq0a             ; set new IRQ 0 protected mode vector
                call    [_setirqvect]
                mov     edi,irq_stub_buf        ; set real mode IRQ 0 callback
                call    _rmpmirqset
                push    eax                     ; store old real mode IRQ 0 address

                mov     B[gs:0b8000h+158],' '   ; put space on screen

                mov     B[v86r_ah],0            ; wait for key with INT 16h AH=0
                mov     al,16h
                int     33h

                mov     edx,pmirq0b             ; set new protected mode IRQ 0
                call    [_setirqvect]
                mov     edi,irq_stub_buf        ; update real mode callback
                call    _rmpmirqset             ;  ignore the EAX passed back this
                                                ;  time since its just the address
                                                ;  of the old callback

                mov     B[gs:0b8000h+158],' '   ; put space on screen

                mov     B[v86r_ah],0            ; wait for key with INT 16h AH=0
                mov     al,16h
                int     33h

                pop     eax                     ; restore old real mode IRQ 0 vector
                call    _rmpmirqfree
                pop     edx                     ; restore old protected mode IRQ 0
                call    [_setirqvect]           ;  vector, though you dont need to do
                                                ;  this before exiting
                jmp     _exit

;
pmirq0a:                ; I think these handlers are pretty self-explanatory
                push    eax
                push    ds
                mov     ds,[cs:_selzero]
                xor     B[0B8000h+158],' '^'0'
                pop     ds
                mov     al,20h
                out     20h,al
                pop     eax
                sti
                iretd

;
pmirq0b:
                push    eax
                push    ds
                mov     ds,[cs:_selzero]
                xor     B[0B8000h+158],' '^'1'
                pop     ds
                mov     al,20h
                out     20h,al
                pop     eax
                sti
                iretd

irq_stub_buf    times 21 db ?                   ; buffer for IRQ callback stub
