;    GRDB - debugger for dos with 32-bit extensions
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
;
; SEARCH.ASM
;
; Function: Search memory
;
	;MASM MODE
	.MODEL SMALL
	.386


include	eprints.inc 
include	einput.inc 
include	emtrap.inc 
include	eoptions.inc

	PUBLIC	search
	EXTRN	paddr:PROC
	.data
PSParglen	dw	0	;#bytes in GRDBPSP:80h buffer


	.CODE
search	PROC
	push	es
	mov	[PSParglen],0
	call	WadeSpace
	jz	errx
	call	ReadAddress	; read address
	jc	errx
	mov	ecx,ebx
	call	defDS		; get DS
	call	WadeSpace
	jz	errx
	push	ecx
	mov	di,dx
	push	di
	call	ReadAddress	; read len
	pop	di
	pop	ecx
	jc	errx
	or	edx,edx
	jnz	hasseg2
	mov	dx,di		;default to first seg
hasseg2:
	mov	es,[psp]
	push	di
	mov	di,80h
grablp:				; read rest of params
	call	WadeSpace
	jz	grabdone
	cmp	al,"'"
	jz	readstring
	cmp	al,'"'
	jnz	readnum
readstring:             	; read a quoted string
	inc	si
readstringlp:
	lodsb
	cmp	al,13
	jz	grabdone
	cmp	al,'"'
	jz	grablp
	cmp	al,"'"
	jz	grablp
	stosb
	inc	[PSParglen]
	cmp	[PSParglen],080h
	jnc	errx
	jmp	readstringlp

readnum:			; read an (8-bit) number
	push	di
	push	cx
	call	ReadNumber
	pop	cx
	pop	di
	jc	errx2
	stosb
	inc	[PSParglen]
	cmp	[PSParglen],080h
	jnc	errx
	jmp	grablp

grabdone:                       	; all params got now
	pop	di
        test    [optdwordcommand],1     ; if not in flat real
        jnz     gp2
        movzx   ebx,bx                  ; make them 16-bit
        movzx   ecx,cx
gp2:
	test	[PSParglen],0ffh		; see if any search
	jz	errx
	movzx	edi,di
	movzx	eax,dx 			; calculate length
	shl	eax,4
	add	ebx,eax
	mov	edx,edi
	mov	eax,edx
	shl	eax,4
	add	eax,ecx
	sub	ebx,eax			; ds:cx = start, ebx = len
	push	ebx
	call	CRLF
	pop	ebx
	pop	es
	mov	esi,ecx
noseg:
        test    [optdwordcommand],1     ; if not in flat real
        jnz     go1
	cmp	si,8000h	; adjust DS to keep search in bounds
	jc	go1
	sub	si,8000h
    	add	dx,800h
go1:
;	call	ScanKey		; I put this in for debug, but,
;	jnz	nofill2		; good for mistakes too...
	push	es
	mov	es,[psp]
	movzx	ecx,[PSParglen]
	push	ds
	mov	ds,dx
	push	esi
	mov	edi,80h
	db	67h
	repe	cmpsb
	pop	esi
	pop	ds
	pop	es
	jnz	nomatch
	push	ebx
	push	dx
	mov	eax,esi
	call	paddr
	pop	dx
	call	crlf
	pop	ebx
nomatch:
	inc	esi
	dec	ebx
	jne	noseg
	clc
	ret
nofill:
	pop	es
nofill2:
	clc
	ret
errx2:
	pop	di
errx:
	pop	es
	stc
	ret
search	endp
end
