; ************************************************************************
; **									**
; **	bios_dos.inc							**
; **									**
; **	This file defines the services provided by the ROM BIOS and	**
; **		DOS of the IBM-PC family of computers.			**
; **									**
; ************************************************************************

; ROM BIOS
; --------

rom_prt_sc	equ	05H	; ROM PRINT SCREEN INTERRUPT


rom_vid		equ	10H	; ROM VIDEO INTERRUPT

; VIDEO INTERRUPT SERVICES

wr_vid_mode	equ	00H	; WRITE VIDEO MODE
wr_cur_size	equ	01H	; WRITE CURSOR SIZE
wr_cur_pos	equ	02H	; WRITE CURSOR POSITION
rd_cur_pos	equ	03H	; READ CURSOR POSITION
rd_pen_pos	equ	04H	; READ LIGHT PEN POSITION
wr_act_page	equ	05H	; WRITE ACTIVE PAGE
scroll_up	equ	06H	; SCROLL WINDOW UP
scroll_down	equ	07H	; SCROLL WINDOW DOWN
rd_char_attr	equ	08H	; READ CHARACTER AND ATTRIBUTE
wr_char_attr	equ	09H	; WRITE CHARACTER AND ATTRIBUTE
wr_char		equ	0AH	; WRITE CHARACTER
wr_col_pal	equ	0BH	; WRITE COLOR PALETTE
wr_pixel	equ	0CH	; WRITE PIXEL
rd_pixel	equ	0DH	; READ PIXEL
wr_tty		equ	0EH	; WRITE TTY CHARACTER
rd_vid_mode	equ	0FH	; READ VIDEO MODE
wr_pal_reg	equ	10H	; PC-JR WRITE COLOR PALETTE REGISTER
wr_string	equ	13H	; PC-AT WRITE STRING


rom_equ		equ	11H	; ROM EQUIPMENT INTERRUPT


rom_mem		equ	12H	; ROM MEMORY SIZE INTERRUPT


rom_disk	equ	13H	; ROM DISKETTE INTERRUPT

; DISKETTE INTERRUPT SERVICES

rst_disk	equ	00H	; RESET DISKETTE SYSTEM
rd_disk_stat	equ	01H	; READ DISKETTE STATUS
rd_disk_sect	equ	02H	; READ DISKETTE SECTOR
wr_disk_sect	equ	03H	; WRITE DISKETTE SECTOR
ver_disk_sect	equ	04H	; VERIFY DISKETTE SECTOR
fmt_disk_trk	equ	05H	; FORMAT DISKETTE TRACK
rd_disk_parm	equ	08H	; PC-AT READ DISKETTE PARAMETERS
init_disk_parm	equ	09H	; PC-AT INITIALIZE DISKETTE PARAMETERS
rd_disk_long	equ	0AH	; PC-AT READ DISKETTE LONG
wr_disk_long	equ	0BH	; PC-AT WRITE DISKETTE LONG
disk_seek	equ	0CH	; PC-AT SEEK DISKETTE TRACK
alt_reset_disk	equ	0DH	; PC-AT ALTERNATE DISKETTE RESET
test_disk_rdy	equ	10H	; PC-AT TEST FOR DISKETTE READY 
recal_disk	equ	11H	; PC-AT RECALIBRATE DISKETTE
disk_diag	equ	14H	; PC-AT DISKETTE DIAGNOSTICS
rd_disk_type	equ	15H	; PC-AT READ DISKETTE TYPE
chg_disk_stat	equ	16H	; PC-AT CHANGE DISKETTE STATUS
wr_disk_type	equ	17H	; PC-AT WRITE DISKETTE TYPE


rom_serial	equ	14H	; ROM SERIAL PORT INTERRUPT

; SERIAL PORT INTERRUPT SERVICES

init_port	equ	00H	; INITIALIZE SERIAL PORT
tx_char		equ	01H	; TRANSMIT CHARACTER
rx_char		equ	02H	; RECEIVE CHARACTER
rd_port_stat	equ	03H	; READ SERIAL PORT STATUS


rom_dev		equ	15H	; ROM DEVICE INTERRUPT

; DEVICE INTERRUPT SERVICES

cass_on		equ	00H	; TURN CASSETTE MOTOR ON
cass_off	equ	01H	; TURN CASSETTE MOTOR OFF
cass_rd		equ	02H	; READ CASSETTE DATA BLOCK
cass_wr		equ	03H	; WRITE CASSETTE DATA BLOCK
open_dev	equ	80H	; PC-AT OPEN DEVICE
close_dev	equ	81H	; PC-AT CLOSE DEVICE
term_dev	equ	82H	; PC-AT TERMINATE DEVICE
event_wait	equ	83H	; PC-AT EVENT WAIT
joystick	equ	84H	; PC-AT JOYSTICK
sys_req		equ	85H	; PC-AT Sys Req KEY
wait		equ	86H	; PC-AT WAIT
move_block	equ	87H	; PC-AT MOVE BLOCK
rd_ext_mem	equ	88H	; PC-AT READ EXTENDED MEMORY SIZE
virtual_mem	equ	89H	; PC-AT SWITCH TO VIRTUAL MEMORY
dev_busy	equ	90H	; PC-AT DEVICE BUSY LOOP
complete_int	equ	91H	; PC-AT SET FLAG AND COMPLETE INTERRUPT


rom_key		equ	16H	; ROM KEYBOARD INTERRUPT

; KEYBOARD INTERRUPT SERVICES

rd_key		equ	00H	; READ KEYBOARD
test_key	equ	01H	; TEST KEYBOARD
rd_shift	equ	02H	; READ SHIFT STATUS
key_delay	equ	03H	; PC-JR TYPEMATIC DELAY
key_click	equ	04H	; PC-JR KEYBOARD CLICK


rom_print	equ	17H	; ROM PRINTER INTERRUPT

; PRINTER INTERRUPT SERVICES

print_char	equ	00H	; PRINT CHARACTER
init_print	equ	01H	; INITIALIZE PRINTER
rd_print_stat	equ	02H	; READ PRINTER STATUS


rom_basic	equ	18H	; ROM START BASIC INTERRUPT


rom_reboot	equ	19H	; ROM REBOOT INTERRUPT


rom_time	equ	1AH	; ROM REAL TIME CLOCK INTERRUPT

; REAL TIME CLOCK INTERRUPT SERVICES

rd_count	equ	00H	; READ CLOCK COUNT
wr_count	equ	01H	; WRITE CLOCK COUNT
rd_time		equ	02H	; PC-AT READ TIME
wr_time		equ	03H	; PC-AT WRITE TIME
rd_date		equ	04H	; PC-AT READ DATE
wr_date		equ	05H	; PC-AT WRITE DATE
set_alarm	equ	06H	; PC-AT SET ALARM
reset_alarm	equ	07H	; PC-AT RESET ALARM


; DOS
; ---

dos_term	equ	20H	; DOS PROGRAM TERMINATION INTERRUPT


dos_func	equ	21H	; DOS FUNCTION INTERRUPT

; FUNCTION INTERRUPT FUNCTIONS

term		equ	00H	; DOS1 - TERMINATE PROGRAM
key_in_echo	equ	01H	; DOS1 - KEYBOARD INPUT WITH ECHO
disp_out	equ	02H	; DOS1 - DISPLAY OUTPUT
serial_in	equ	03H	; DOS1 - SERIAL INPUT
serial_out	equ	04H	; DOS1 - SERIAL OUTPUT
printer_out	equ	05H	; DOS1 - PRINTER OUTPUT
console_io	equ	06H	; DOS1 - DIRECT CONSOLE I/O
dir_key_in	equ	07H	; DOS1 - DIRECT KEYBOARD INPUT
key_in		equ	08H	; DOS1 - KEYBOARD INPUT WITHOUT ECHO
disp_string	equ	09H	; DOS1 - DISPLAY STRING
buf_key_in	equ	0AH	; DOS1 - BUFFERED KEYBOARD INPUT
chk_key_stat	equ	0BH	; DOS1 - CHECK KEYBOARD STATUS
clr_key_func	equ	0CH	; DOS1 - CLEAR KEY BUFFER AND PERFORM FUNCTION
reset_disk	equ	0DH	; DOS1 - RESET DISK
sel_drive	equ	0EH	; DOS1 - SELECT CURRENT DRIVE
open_file	equ	0FH	; DOS1 - OPEN FILE
close_file	equ	10H	; DOS1 - CLOSE FILE
search_first	equ	11H	; DOS1 - SEARCH FOR FIRST MATCHING FILE
search_next	equ	12H	; DOS1 - SEARCH FOR NEXT MATCHING FILE
delete_file	equ	13H	; DOS1 - DELETE FILE
rd_seq_rec	equ	14H	; DOS1 - READ SEQUENTIAL RECORD
wr_seq_rec	equ	15H	; DOS1 - WRITE SEQUENTIAL RECORD
create_file	equ	16H	; DOS1 - CREATE FILE
rename_file	equ	17H	; DOS1 - RENAME FILE
rd_cur_drive	equ	19H	; DOS1 - REPORT CURRENT DRIVE
set_dta		equ	1AH	; DOS1 - SET DISK TRANSFER AREA FUCNTION
rd_fat_1	equ	1BH	; DOS1 - READ CURRENT DRIVE'S FAT
rd_fat_2	equ	1CH	; DOS1 - READ ANY DRIVE'S FAT
rd_ran_rec1	equ	21H	; DOS1 - READ RANDOM FILE RECORD
wr_ran_rec1	equ	22H	; DOS1 - WRITE RANDOM FILE RECORD
rd_file_size	equ	23H	; DOS1 - REPORT FILE SIZE
set_ran_rec	equ	24H	; DOS1 - SET RANDOM RECORD FIELD SIZE
set_int_vec	equ	25H	; DOS1 - SET INTERRUPT VECTOR
create_seg	equ	26H	; DOS1 - CREATE PROGRAM SEGMENT FUCNTION
rd_ran_rec2	equ	27H	; DOS1 - READ RANDOM FILE RECORD
wr_ran_rec2	equ	28H	; DOS1 - WRITE RANDOM FILE RECORD FUCNTION
parse_name	equ	29H	; DOS1 - PARSE FILENAME
get_date	equ	2AH	; DOS1 - GET DATE
set_date	equ	2BH	; DOS1 - SET DATE
get_time	equ	2CH	; DOS1 - GET TIME
set_time	equ	2DH	; DOS1 - SET TIME
set_verify	equ	2EH	; DOS1 - SET DISK WRITE VERIFICATION MODE
get_dta		equ	2FH	; DOS2 - GET DISK TRANSFER AREA ADDRESS
get_ver		equ	30H	; DOS2 - GET DOS VERSION NUMBER
keep		equ	31H	; DOS2 - ADVANCED TERMINATE BUT STAY RESIDENT
cntrl_brk	equ	33H	; DOS2 - GET/SET CONTROL BREAK STATUS
get_int_vec	equ	35H	; DOS2 - GET INTERRUPT VECTOR
get_space	equ	36H	; DOS2 - GET DISK FREE SPACE
get_country	equ	38H	; DOS2 - GET COUNTRY INFORMATION
mkdir		equ	39H	; DOS2 - MAKE DIRECTORY
rmdir		equ	3AH	; DOS2 - REMOVE DIRECTORY
chdir		equ	3BH	; DOS2 - CHANGE CURRENT DIRECTORY FUCNTION
create		equ	3CH	; DOS2 - CREATE FILE
open		equ	3DH	; DOS2 - OPEN FILE
close		equ	3EH	; DOS2 - CLOSE FILE
read		equ	3FH	; DOS2 - READ FILE/DEVICE
write		equ	40H	; DOS2 - WRITE FILE/DEVICE
delete		equ	41H	; DOS2 - DELETE FILE
move_pointer	equ	42H	; DOS2 - MOVE FILE POINTER
chmod		equ	43H	; DOS2 - CHANGE FILE MODE
ioctl		equ	44H	; DOS2 - DEVICE I/O CONTROL
dup		equ	45H	; DOS2 - DUPLICATE FILE HANDLE
cdup		equ	46H	; DOS2 - FORCE FILE HANDLE DUPLICATION
get_dir		equ	47H	; DOS2 - GET CURRENT DIRECTORY
allocate	equ	48H	; DOS2 - ALLOCATE MEMORY
free		equ	49H	; DOS2 - FREE MEMORY
set_block	equ	4AH	; DOS2 - MODIFY ALLOCATED MEMORY BLOCK
exec		equ	4BH	; DOS2 - LOAD/EXECUTE PROGRAM
term_proc	equ	4CH	; DOS2 - TERMINATE PROCESS
get_code	equ	4DH	; DOS2 - GET SUBPROGRAM RETURN CODE
find_first	equ	4EH	; DOS2 - FIND FIRST FILE MATCH
find_next	equ	4FH	; DOS2 - FIND NEXT FILE MATCH
get_verify	equ	54H	; DOS2 - GET FILE WRITE VERIFY STATE
rename		equ	56H	; DOS2 - RENAME FILE
date_time	equ	57H	; DOS2 - GET/SET FILE DATE/TIME
get_err		equ	59H	; DOS3 - GET EXTENDED RETURN CODE
create_temp	equ	5AH	; DOS3 - CREATE TEMPORARY FILE
create_new	equ	5BH	; DOS3 - CREATE NEW FILE
file_lock	equ	5CH	; DOS3 - LOCK/UNLOCK FILE ACCESS
get_psp		equ	62H	; DOS3 - GET PROGRAM SEGMENT PREFIX ADDRESS
dos_rd_abs	equ	25H	; DOS ABSOLUTE DISK READ INTERRUPT
dos_wr_abs	equ	26H	; DOS ABSOLUTE DISK WRITE INTERRUPT
dos_term_res	equ	27H	; DOS TERMINATE/RESIDENT INTERRUPT


dos_spool	equ	2FH	; DOS PRINT SPOOLER INTERRUPT

; PRINT SPOOLER INTERRUPT FUNCTIONS

spool_query	equ	00H	; INSTALLED QUERY
spool_submit	equ	01H	; SUBMIT FILE
spool_cancel	equ	02H	; CANCEL FILE
spool_canall	equ	03H	; CANCEL ALL FILES
spool_queue	equ	04H	; EXAMINE QUEUE
spool_null	equ	05H	; NULL
